// toipullproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999


#include "toipullproducer.h"

TOIPullProducer::TOIPullProducer() {
  needBefore = needAfter = 0;
}

bool TOIPullProducer::canGetValue(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & m = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
    if (!(*i).second->canGetValue(sampleNum-needBefore, (*i).first) ||
        !(*i).second->canGetValue(sampleNum+needAfter, (*i).first)) return false;
  }
  return true;
}

bool TOIPullProducer::canGetPrevValue(long sampleNum, TOI const& toi) {
  return canGetValue(sampleNum-1, toi);
}
 
bool TOIPullProducer::canGetNextValue(long sampleNum, TOI const& toi) {
  return canGetValue(sampleNum+1, toi);
}

bool TOIPullProducer::canGetValueLater(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & m = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
    if (!(*i).second->canGetValueLater(sampleNum+needAfter, (*i).first)) return false;
  }
  return true;
}


double TOIPullProducer::getPrevValue(long& sampleNum, TOI const& toi) {
  return getValue(--sampleNum, toi);
}

double TOIPullProducer::getNextValue(long& sampleNum, TOI const& toi) {
  return getValue(++sampleNum, toi);
}


long TOIPullProducer::firstSampleNum(TOI const& toi) {
  long xx = -999999999L;
  map<TOI, TOIProducer*> & m = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
    long x = (*i).second->firstSampleNum((*i).first) + needBefore;
    if (x > xx) xx=x;
  }
  return xx;
}

long TOIPullProducer::lastSampleNum(TOI const& toi) {
  long xx = 999999999L;
  map<TOI, TOIProducer*> & m = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
    long x = (*i).second->lastSampleNum((*i).first) - needAfter;
    if (x < xx) xx=x;
  }
  return xx;
}

void TOIPullProducer::propagateLowBound(TOI const& toi, long sampleNum) {
  CHKPROD
  map<TOI, TOIProducer*> & need = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = need.begin(); i != need.end(); i++) {
    (*i).second->wontNeedEarlier((*i).first, this, sampleNum-needBefore);
  }
}
