// tsidproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#include "tsidproducer.h"
#include "archexc.h"
#include "requesthandler.h"
#include "tsid.h"
#include "archparam.h"

#define tsid "tsid"

static TSid myTS;

TSidProducer::TSidProducer() {
  possibleTOIs.insert(TOI(tsid, TOI::unspec, "", "seconds"));  
}

string TSidProducer::getName() {
  return("TSidProducer 1.0");
}


double TSidProducer::getValue(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & m = neededTOIs[toi];
  // Seulement longitude... 
  TOI const& longTOI = (*m.begin()).first;
  TOIProducer* longProd =  (*m.begin()).second;
  myTS.setLongitude(longProd->getValue(sampleNum, longTOI));
  return myTS.getLST(archParam.acq.SN2MJD(sampleNum));
  
}


set<TOI> TSidProducer::reqTOIFor(TOI const& toi) {
  set<TOI> t; 
  if (toi.name == tsid) {
    t.insert(TOI("longitude", TOI::unspec, "interp"));
  } else {
    throw ArchExc("Cannot produce "+toi.name);
  }
  return t;
}





