// archtoimain.cc
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999

#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>

#include "archeopsfile.h"

#include "archtoi.h"
#include "toimanager.h"

//#include <profiler.h>

#ifdef __MWERKS__
#include <console.h>
#endif

using namespace std;  //introduces namespace std

int main(int argc, char** argv)
{	
#ifdef __MWERKS__
    argc = ccommand(&argv);
#endif


    if (argc != 3) {
      cerr << "usage: archtoi reqfile datafile" << endl;
      cerr << "or:    archtoi -h reqfile" << endl;
      return(-1);
    }
    
//    ProfilerInit(collectDetailed, bestTimeBase, 10000, 200);

    if (argv[1] == string("-h")) {
      ArchTOI toi(argv[2]);
      TOIManager::dumpAvailTOIs(cout);
      exit(0);
    }

    
    try {
      ArchTOI toi(argv[1]);
      toi.run(argv[2]);
    } catch (ArchExc exc) {
      cerr << exc.Msg() << endl; 
      exit(-1);
    }
    
//    ProfilerDump("\pprofiler.data");
    return(0);
}

