// toi.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "toi.h"
#include "tokenizer.h"
#include "archexc.h"

vector<TOI> TOI::alltois;

TOI::TOI(string n, int i, string opts, string u) 
: name(n), index(i), unit(u)
{
  options = Tokenizer(opts).getTokenSet();
  findref();
}

TOI::TOI(string n, int i, string opts, string u, string reqopts) 
: name(n), index(i), unit(u)
{
  options = Tokenizer(opts).getTokenSet();
  reqOptions = Tokenizer(reqopts).getTokenSet();
  options.insert(reqOptions.begin(), reqOptions.end());
  findref();
}

TOI::TOI(string n, int i, set<string> opts, string u) 
: name(n), options(opts), index(i), unit(u)
{
  findref();
}

TOI::TOI(string s, string u) 
: index(unspec), unit(u)
{
  vector<string> v = Tokenizer(s).getTokenVector();
  if (v.empty()) throw ArchExc("TOI::TOI called with empty string");
  vector<string>::iterator i = v.begin();
  name = *i;
  i++;
  if (i == v.end()) return;
  string& s1 = *i;
  if (s1[0]>='0' && s1[0]<='9') {
    index = atoi(s1.c_str());
    i++;
  }
  options = set<string>(i, v.end());
  findref();
}

void TOI::findref() {
  for (vector<TOI>::iterator i = alltois.begin();
       i != alltois.end(); i++) {
    if ((*i).name == name && (*i).index == index && (*i).options == options) {
       ref = (*i).ref;
       return;
    }
  }
  ref = alltois.size();
  alltois.push_back(*this);
}

string TOI::fullName() const {
 string s = name;
 if (index == all) { s += " all";}
 else if (index != unspec) { 
   char idx[20]; sprintf(idx, "%d", index);
   s += string(" ")+idx;
 }
 for (set<string>::const_iterator i = options.begin(); i!=options.end(); i++) {
   s += " " + *i;
 }
 if (unit != "") s += " (" + unit + ")";
 return s;
}
