// toiflagger.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999


#include "toiflagger.h"
#include "toimanager.h"
#include "archexc.h"

TOIFlagger::TOIFlagger() {
}


string TOIFlagger::getName() {
  return("TOIFlagger 1.0");
}

bool TOIFlagger::canProduce(TOI const& toi) {
  // 1. Already in cache ?
  map<TOI, map<TOI, TOIProducer*> >::const_iterator j = neededTOIs.find(toi);
  if (j != neededTOIs.end()) return true;

  // 2. Should have flag
  if (toi.options.find("flag") == toi.options.end()) return false;
  
  // 3. Can get non flag
  TOI toi2 = toi;
  toi2.options.erase("flag");
  TOIProducer* prod = TOIManager::findTOIProducer(toi2);
  set<string> opts = prod->getAvailOptions(toi2);
  if (opts.find("flag") != opts.end()) return false; // already handled
  
  map<TOI, TOIProducer*> fullInputTOI;
  fullInputTOI[toi2] = prod;
  neededTOIs[toi] = fullInputTOI;
  return true;
}

set<TOI> TOIFlagger::reqTOIFor(TOI const& toi) {
  set<TOI> x;
  if (!canProduce(toi)) return x;
  x.insert((*neededTOIs[toi].begin()).first);
  return x;
}

bool TOIFlagger::canGetValue(long, TOI const& ) {
  return true;
}

bool TOIFlagger::canGetValueLater(long, TOI const& ) {
  return false;
}

double TOIFlagger::getValue(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & inp = neededTOIs[toi];
  TOIProducer* prod  = (*inp.begin()).second;
  TOI          inTOI = (*inp.begin()).first;

  return (prod->canGetValue(sampleNum, inTOI)) ? 1 : 0;
}


