// rotspeed.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#include "rotspeed.h"
#include "archexc.h"
#include "archparam.h"
#include "templocator.h"

#define rotSpeed        "rotSpeed"


RotSpeed::RotSpeed() {
  possibleTOIs.insert(TOI(rotSpeed,         TOI::unspec, "interp", "deg/s"));
  sn1 = sn2 = -1;
}

string RotSpeed::getName() {
  return("RotSpeed 1.0");
}

bool RotSpeed::canGetValue(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & m = neededTOIs[toi];

  TOIProducer* azProd;
  TOI azTOI;
  
  if (sn1<0 || sn2<0 || sampleNum<sn1 || sampleNum >= sn2) {
	  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
	    TOI const& inToi = (*i).first;
	    TOIProducer* prod =  (*i).second;
	    
	    if (inToi.name == "rotSpeedSample1")  {
	      if (!prod->canGetValue(sampleNum, inToi)) return false;
	      sn1 = (long) prod->getValue(sampleNum, inToi);
	    }
	    if (inToi.name == "rotSpeedSample2")  {
	      if (!prod->canGetValue(sampleNum, inToi)) return false;
	      sn2 = (long) prod->getValue(sampleNum, inToi);
	    }
	    if (inToi.name == "azimuthFPC")  {
	      azProd = prod;
	      azTOI = inToi;
	    }
	  }
  } else {
	  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
	    TOI const&  inToi = (*i).first;
	    TOIProducer* prod =  (*i).second;
	    if (inToi.name == "azimuthFPC")  {
	      azProd = prod;
	      azTOI = inToi;
	    }
	  }
  }
  
  if (!azProd->canGetValue(sn1, azTOI)) return false;
  if (!azProd->canGetValue(sn2, azTOI)) return false;
  
  return true;
}

bool RotSpeed::canGetValueLater(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & m = neededTOIs[toi];

  TOIProducer* azProd;
  TOI azTOI;
  
  if (sn1<0 || sn2<0 || sampleNum<sn1 || sampleNum >= sn2) {
	  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
	    TOI const&  inToi = (*i).first;
	    TOIProducer* prod =  (*i).second;
	    
	    if (inToi.name == "rotSpeedSample1")  {
	      if (prod->canGetValueLater(sampleNum, inToi)) return true;
	      sn1 = (long) prod->getValue(sampleNum, inToi);
	    }
	    if (inToi.name == "rotSpeedSample2")  {
	      if (prod->canGetValueLater(sampleNum, inToi)) return true;
	      sn2 = (long) prod->getValue(sampleNum, inToi);
	    }
	    if (inToi.name == "azimuthFPC")  {
	      azProd = prod;
	      azTOI = inToi;
	    }
	  }
  } else {
	  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
	    TOI const&  inToi = (*i).first;
	    TOIProducer* prod =  (*i).second;
	    if (inToi.name == "azimuthFPC")  {
	      azProd = prod;
	      azTOI = inToi;
	    }
	  }
  }
  
  if (azProd->canGetValueLater(sn1, azTOI)) return true;
  if (azProd->canGetValueLater(sn2, azTOI)) return true;
  
  return false;
}



double RotSpeed::getValue(long sampleNum, TOI const& toi) {
  if (!canGetValue(sampleNum, toi)) return -99999;

  map<TOI, TOIProducer*> &m = neededTOIs[toi];

  TOIProducer* azProd;
  TOI azTOI;
  
  if (sn1<0 || sn2<0 || sampleNum<sn1 || sampleNum >= sn2) {
	  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
	    TOI const& inToi = (*i).first;
	    TOIProducer* prod =  (*i).second;
	    
	    if (inToi.name == "rotSpeedSample1")  {
	      if (prod->canGetValueLater(sampleNum, inToi)) return true;
	      sn1 = (long) prod->getValue(sampleNum, inToi);
	    }
	    if (inToi.name == "rotSpeedSample2")  {
	      if (prod->canGetValueLater(sampleNum, inToi)) return true;
	      sn2 = (long) prod->getValue(sampleNum, inToi);
	    }
	    if (inToi.name == "azimuthFPC")  {
	      azProd = prod;
	      azTOI = inToi;
	    }
	  }
  } else {
	  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
	    TOI const& inToi = (*i).first;
	    TOIProducer* prod =  (*i).second;
	    if (inToi.name == "azimuthFPC")  {
	      azProd = prod;
	      azTOI = inToi;
	    }
	  }
  }
  
  double az1 = azProd->getValue(sn1, azTOI);
  double az2 = azProd->getValue(sn2, azTOI);

  return (az1 - az2 + 360)/(sn2-sn1)/ archParam.acq.perEch;
}


set<TOI> RotSpeed::reqTOIFor(TOI const& toi) {
  set<string> opts = toi.options;
  set<TOI> t; 
  t.insert(TOI("rotSpeedSample1",  TOI::unspec, opts));
  t.insert(TOI("rotSpeedSample2",  TOI::unspec, opts));
  t.insert(TOI("azimuthFPC",       TOI::unspec, opts));
  return t;
}







