// toirepeater.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999


#include "toirepeater.h"
#include "toimanager.h"
#include "archexc.h"

TOIRepeater::TOIRepeater() {
}


string TOIRepeater::getName() {
  return("TOIRepeater 1.0");
}

bool TOIRepeater::canProduce(TOI const& toi) {
  // 1. Already in cache ?
  map<TOI, map<TOI, TOIProducer*> >::const_iterator j = neededTOIs.find(toi);
  if (j != neededTOIs.end()) return true;

  // 2. Should have repet
  if (toi.options.find("repet") == toi.options.end()) return false;
  
  // 3. Can get non interp
  TOI toi2 = toi;
  toi2.options.erase("repet");
  TOIProducer* prod = TOIManager::findTOIProducer(toi2);
  set<string> opts = prod->getAvailOptions(toi2);
  if (opts.find("repet") != opts.end()) return false; // already handled
  if (opts.find("interp") != opts.end()) return false;  // not compatible !
  
  map<TOI, TOIProducer*> fullInputTOI;
  fullInputTOI[toi2] = prod;
  neededTOIs[toi] = fullInputTOI;
  return true;
}

set<TOI> TOIRepeater::reqTOIFor(TOI const& toi) {
  set<TOI> x;
  if (!canProduce(toi)) return x;
  x.insert((*neededTOIs[toi].begin()).first);
  return x;
}

bool TOIRepeater::canGetValue(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & inp = neededTOIs[toi];
  TOIProducer* prod  = (*inp.begin()).second;
  TOI const&   inTOI = (*inp.begin()).first;
  
  if (prod->canGetValue(sampleNum, inTOI)) return true; // direct
  if (prod->canGetPrevValue(sampleNum, inTOI)) return true;
  return false;
}

bool TOIRepeater::canGetValueLater(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & inp = neededTOIs[toi];
  TOIProducer* prod  = (*inp.begin()).second;
  TOI const&   inTOI = (*inp.begin()).first;
  
  if (prod->canGetValue(sampleNum, inTOI)) return false; // direct
  if (prod->canGetValueLater(sampleNum, inTOI)) return true; // direct
  //if (prod->canGetPrevValue(sampleNum, inTOI)) return false; // can get now
  return false;
}

double TOIRepeater::getValue(long sampleNum, TOI const& toi) {
  map<TOI, TOIProducer*> & inp = neededTOIs[toi];
  TOIProducer* prod  = (*inp.begin()).second;
  TOI const&   inTOI = (*inp.begin()).first;

  if (prod->canGetValue(sampleNum, inTOI))
     return prod->getValue(sampleNum, inTOI); // direct
     
  long sn1 = sampleNum;
  double v1 = prod->getPrevValue(sn1, inTOI);
  
  return v1;
}


void TOIRepeater::propagateLowBound(TOI const& toi, long sampleNum) {
  CHKPROD
  map<TOI, TOIProducer*> & inp = neededTOIs[toi];
  TOIProducer* prod  = (*inp.begin()).second;
  TOI const&   inTOI = (*inp.begin()).first;
  if (prod->canGetPrevValue(sampleNum,toi)) {
    prod->getPrevValue(sampleNum, toi);
    sampleNum--;
    prod->wontNeedEarlier(toi, this, sampleNum);
  }
}

