#include <stdlib.h>
#include <stdio.h>
#ifdef OSF1
#include <dlfcn.h>
#else
#define C_NO_SHLIBS
#endif

#include <string>
#include "psighand.h"
#include "dynccd.h"

#include "timing.h"
#include "sambainit.h"

#include "pistdimgapp.h"



/*  ================================ MAIN() =================================  */

int main(int narg, char *arg[])
{
int ofa;
int fgsig, fgred;

SambaInitiator sambainit;
   
InitTim();

ofa = 1;   
if (narg > 1)
  {
  if (strcmp(arg[1],"-h") == 0) 
    {
    puts("\n piapp: Programme d'analyse interactive ");
    puts("Usage: piapp [-nored] [-nosig]");
    exit(0);
    }
  }

ofa = 1;
fgred = fgsig = true;
if (  (narg > 1) && (strcmp(arg[1],"-nored") == 0) )  { fgred=false;  ofa = 2; }
if (  (narg > 1) && (strcmp(arg[1],"-nosig") == 0) )  { fgsig=false;  ofa = 2; }
if (  (narg > 2) && (strcmp(arg[2],"-nored") == 0) )  { fgred=false;  ofa = 3; }
if (  (narg > 2) && (strcmp(arg[2],"-nosig") == 0) )  { fgsig=false;  ofa = 3; }


PIStdImgApp * app = new PIStdImgApp(narg-ofa, arg+ofa);
if (!fgred) app->RedirectStdOutErr(false);
else app->RedirectStdOutErr(true);
if (fgsig)  app->CatchSignals(true);

int rc = 0;
bool cont = true;
while(cont) {
  rc = 0;   cont = false;
  app->SetReady();
  if (fgred) app->RedirectStdOutErr(true);
  try {
  app->Run();
  }  catch (PException exc) {
     char ans[32],rep;
     app->Stop();
     app->RedirectStdOutErr(false);  
     fflush(stdout); 
     cout << endl; 
     cerr << endl;
     cout << "PIStdImg/main() Exception catched ! " << exc.Msg() << endl;
     cout << " exit <CR> , continue c<CR> , close-windows, continue k<cr> ? " << endl; 
     gets(ans);
     rep = toupper(ans[0]);  
     if ((rep != 'C')||(rep != 'K'))  { cont = false; rc = 99; }
     else { cont = true; if (rep == 'K') app->CloseAllWindows(); }
  } 
}

app->RedirectStdOutErr(false);  
delete app;
printf("piapp : Exiting .... Rc= %d \n", rc); 
exit(rc);
}

