#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <complex>
#include "pexceptions.h"
#include "ppersist.h"
#include "peidainit.h"
#include "ndatablock.h"
#include "sversion.h"

// ---  Classe d'initialisation de PEIDA++, (PPersistMgr en particulier)
int PeidaInitiator::FgInit = 0;

PeidaInitiator::PeidaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

  InitFailNewHandler();

  #ifdef xx__mac__
  //InitToolBox();
  //SIOUXSettings.initializeTB = FALSE;
  SIOUXSettings.autocloseonquit = FALSE;
  SIOUXSettings.asktosaveonclose = FALSE;
  SIOUXSettings.showstatusline = TRUE;
  #endif

  PIOPersist::Initialize();
  PPRegister(FIO_NDataBlock<uint_1>);
  PPRegister(FIO_NDataBlock<uint_2>);
  PPRegister(FIO_NDataBlock<int_2>);
  PPRegister(FIO_NDataBlock<int_4>);
  PPRegister(FIO_NDataBlock<int_8>);
  PPRegister(FIO_NDataBlock<uint_4>);
  PPRegister(FIO_NDataBlock<uint_8>);
  PPRegister(FIO_NDataBlock<r_4>);
  PPRegister(FIO_NDataBlock<r_8>);
  PPRegister(FIO_NDataBlock< complex<float> >);
  PPRegister(FIO_NDataBlock< complex<double> >);

//DEL  PPersistMgr::classList = new PPersistMgr::ClassList;
//DEL  PShPersist::objList    = new PShPersist::ObjList;
  

#if (!defined(__GNUG__) && !defined(__MWERKS__) && !defined(HPUX))
  // pas de bufferisation pour printf   cmv 18/3/97 selon E.A.
  // setvbuf(stdout,NULL,_IOLBF,0); setvbuf(stderr,NULL,_IOLBF,0);
  setlinebuf(stdout);
  setlinebuf(stderr);
#endif

  // si var env PEIDA_NOPRTVER definie pas de print
  if(!getenv("SOPHYA_NOPRTVER")) PrintPeidaVersion();
}

PeidaInitiator::~PeidaInitiator()
{
  FgInit--;
/*
  if (FgInit == 0)
    {
    delete PPersistMgr::classList; PPersistMgr::classList = NULL;
    delete PShPersist::objList;    PShPersist::objList = NULL;
    }
    */
}

double PeidaInitiator::Version(bool fgprt)
{
if (fgprt) {
  char* compiler;
  #ifdef __GNUG__
  compiler = "gcc " __VERSION__;
  #endif
  #ifdef __DECCXX
  compiler = "cxx " ;
  #endif
  #ifdef __aCC__
  compiler = const_cast<char *>("HP-aCC ") ;
  #endif
  #ifdef __KCC__
  compiler = const_cast<char *>("KCC ") ;
  #endif
  #ifdef __SGICC__
  compiler = const_cast<char *>("SGI-CC ") ;
  #endif
  fprintf(stderr,"SOPHYA Version %4.1f Revision %d (%s) -- %s %s %s\n",
          SOPHYA_VERSION, SOPHYA_REVISION, SOPHYA_TAG,
          __DATE__, __TIME__, compiler);
}
return(SOPHYA_VERSION + (SOPHYA_REVISION/1000.));
}
 
// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static PeidaInitiator ppeidainit;
