#include "picmap.h"

PIColorMap::PIColorMap(CMapId id)
: PIColorMapNative(id)
{
   if (!*maps) { // Il faut allouer les trois maps de depart
     maps[0] = new PIColorMap(CMAP_GREY32, 0);
     maps[1] = new PIColorMap(CMAP_GREYINV32, 0);
     maps[2] = new PIColorMap(CMAP_COLRJ32, 0);
   }
   
   switch (id) {
     case CMAP_GREY32 : 
       CopyFrom(maps[0]);
       break;
     case CMAP_GREYINV32 : 
       CopyFrom(maps[1]);
       break;
     case CMAP_COLRJ32 : 
       CopyFrom(maps[2]);
       break;
     default:
       if (!maps[3] || maps[3]->Type() != id) {
         if (maps[3])
           {
           maps[3]->FreeColors();
           delete maps[3];
	   }
         maps[3] = new PIColorMap(id, 0);
       }
       CopyFrom(maps[3]);
   }
}


PIColorMap::PIColorMap(string const& nom, int nCol)
: PIColorMapNative(nom, nCol)
{
  MakeColMap();
}

PIColorMap::PIColorMap(CMapId id, int i)      // Fait une veritable allocation
: PIColorMapNative(id,i)
{
  MakeColMap();
}

PIColorMap::~PIColorMap()
{
  if (mType == CMAP_OTHER)
    FreeColors();
}
