#ifndef PICMAPX_H_SEEN
#define PICMAPX_H_SEEN

#include "picmapgen.h"

typedef   unsigned long PIXColor ;


class PIColorMapX : public PIColorMapGen {
public:
  friend class PIColorMapGen;
  friend class PIPixmapX;

  PIColorMapX(CMapId);
  PIColorMapX(string const& nom, int nCol); 

  inline PIXColor  Color(int index) 
    { return ((index < mNCol) ? mColors[index] : 0); } ;

  virtual PIColor GetColor(int n);
  virtual void AllocColor(PIColor const& col, int index);
  virtual void FreeColors();
//  virtual void MakeColMap();
protected:
  PIColorMapX(CMapId id, int i);      // Fait une veritable allocation
  void CopyFrom(PIColorMapGen*);
  
  PIXColor  * mColors;     // La table des couleurs ...
  PIColor   * mColRGB;     // Composantes RGB  
};

typedef PIColorMapX PIColorMapNative;

#endif
