#include <stdio.h>
#include "pihisto.h"

PIHisto::PIHisto(Histo* histo, bool ad)
: PIScDrawer(), mHisto(histo)
{
  mAdDO = ad;     // Flag pour suppression automatique de mHisto
}

PIHisto::~PIHisto()
{
  if (mAdDO)
    delete mHisto;
}



void
PIHisto::UpdateSize()
{
  if (!mDrawer) return;
  if (mDrawer->LimitsFixed()) return;
  // Commencer par trouver nos limites
  
  double xmin = mHisto->XMin();
  double xmax = (mHisto->XMax());

  double ymax = mHisto->VMax()*1.2;
  double ymin = mHisto->VMin();
  
  if (mDrawWdg)
    mDrawWdg->SetLimits(xmin, xmax, ymin, ymax);
  else 
    mDrawer->SetLimits(xmin, xmax, ymin, ymax);

  mDrawer->SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


void
PIHisto::Draw(double /*xmin*/, double /*ymin*/, double /*xmax*/, double /*ymax*/)
{
  if (!mDrawer) return;
  for (int i=0; i<mHisto->NBins(); i++) {
		double left   = mHisto->BinLowEdge(i);
		double width  = mHisto->BinWidth();
		double bottom = 0;
		double height = (*mHisto)(i);
		mDrawer->DrawFBox(left,bottom,width,height);
		mDrawer->DrawLine(left, bottom, left, bottom + height); // Au moins une ligne...
	}
  DrawStats();
}

void
PIHisto::DrawStats()
{
  // Une boite dans le coin superieur droit
  if (!mDrawer) return;
  double cellHeight = (mDrawWdg->YMax() - mDrawWdg->YMin()) * 0.05;
  double cellWidth  = (mDrawWdg->XMax() - mDrawWdg->XMin()) * 0.23;
  mDrawer->DrawLine(mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax(),
                       mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax() - cellHeight);
  mDrawer->DrawLine(mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax() - cellHeight,
                       mDrawWdg->XMax()            , mDrawWdg->YMax() - cellHeight);
  char label[50];
  sprintf(label, "N = %.6g", mHisto->NData());
  mDrawer->SelFontSz((mDrawWdg->YMax() - mDrawWdg->YMin())/30);
  mDrawer->DrawString(mDrawWdg->XMax() - cellWidth*0.9, mDrawWdg->YMax() - cellHeight*0.8, label);
                       
}
