#ifndef PIDRAWER_H
#define PIDRAWER_H

#include "pibwdggen.h"
#include <list>

enum {
  kStdAxes     = 0x0001,
  kBoxAxes     = 0x0002,
  kTicks       = 0x0004,
  kIntTicks    = 0x0010,
  kExtTicks    = 0x0020,
  kMajTicks    = 0x0040,
  kMinTicks    = 0x0080,
  kLabels      = 0x1000,
  kAxesDflt    = kStdAxes | kTicks | kLabels
};

enum {
  kAxeDirSame     = 0,
  kAxeDirLtoR     = 1,
  kAxeDirRtoL     = 2,
  kAxeDirDownUp   = 3,
  kAxeDirUpDown   = 4
};


class PIDrawer {
public:
                     PIDrawer();
  virtual           ~PIDrawer();

  virtual void       SetLimits(double xmin, double xmax, double ymin, double ymax,
                               int axrl=kAxeDirSame, int ayud=kAxeDirSame);


  virtual void       Erase();
  virtual void       DrawString(double x, double y, char* s, int pos = 0);
  virtual void       DrawLine(double x1, double y1, double x2, double y2);
  virtual void       DrawBox(double x0, double y0, double dx, double dy);
  virtual void       DrawFBox(double x0, double y0, double dx, double dy);
  virtual void       DrawCircle(double x0, double y0, double r);
  virtual void       DrawFCircle(double x0, double y0, double r);
  virtual void       DrawPolygon(double *x, double *y, int n);  
  virtual void       DrawFPolygon(double *x, double *y, int n);
  virtual void       DrawMarker(double x0, double y0);
  virtual void       DrawMarkers(double *x0, double *y0, int n);
  virtual void       DrawPixmap(double x, double y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap);

  virtual double     StringWidth(char const*);
  virtual double     FontHeight(double& asc, double& desc);

  virtual void       SelForeground(PIColors col=PI_Black);
  virtual void       SelBackground(PIColors col=PI_White);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelLine(PILineAtt att=PI_NormalLine);
  virtual void       SelFontSz(double size, PIFontAtt att=PI_RomanFont); 
  virtual void       SelMarker(double size=0, PIMarker mrk=PI_DotMarker); 
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker); 

  virtual void       DrawAxes(int flags = -1);
  virtual void       SetAxesFlags(int flags=kAxesDflt);
    
  virtual void       Draw();
  virtual void       Draw(double xmin, double ymin, double xmax, double ymax);
  
  virtual void       Sc2Local(double x, double y, int& xpix, int& ypix);
  virtual void       Sc2LocalF(double x, double y, float& xpix, float& ypix);
  virtual void       Local2Sc(int xpix, int ypix, double& x, double& y);
  virtual void       DSc2Local(double dx, double dy, int& dxpix, int& dypix);
  


  double XMin() const {return xMin;}
  double XMax() const {return xMax;}
  double YMin() const {return yMin;}
  double YMax() const {return yMax;}

  int    LimitsFixed() const {return limitsFixed;}
  void   FreeLimits() {limitsFixed = 0;}
  void   NoClip() {clip = false;}
  void   Clip() {clip = true;}

//  Les objets/methodes suivants devraient etre protected     
//  Pb avec acces depuis PIBaseWdgGen (Reza 11/07/97) 
  virtual void       SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy);
//  Je declare en public a cause de cxx - Reza 11/07/97 
  struct DrwBWId { int id; PIBaseWdgGen* wdg; };
  
protected:
  friend class PIBaseWdgGen;
  virtual void       Attach(PIBaseWdgGen*, int id);
  virtual void       Detach(PIBaseWdgGen*, int id);

  void CalcTicks();

  void DrawHTicks(double y, double tickUp, double tickDown, double xBeg, double xStep);
  void DrawVTicks(double x, double tickLeft, double tickRight, double yBeg, double yStep);
  void DrawHLabels(double y, double xBeg, double xStep, int just=0);
  void DrawVLabels(double x, double yBeg, double yStep, int just=0);

  
  double xMin, xMax, yMin, yMax; // Valeurs en unites user
  double xOrg, yOrg;             // Position en pixels de (0.0, 0.0)
  double xScale, yScale;         // Pixels par unites graphiques
  int xW0, yW0, xWd, yWd;        // Origine/largeur ds la fenetre de trace
  bool   aXdir, aYdir;           // Sens des axes horiz, vertical 

  double xFirstMajTick, xFirstMinTick;
  double yFirstMajTick, yFirstMinTick;
  double xMajTickStep, xMinTickStep;
  double yMajTickStep, yMinTickStep;
  double xMajTickLen,  xMinTickLen;
  double yMajTickLen,  yMinTickLen;
  
  int limitsFixed;
  int axesFlags;
  
  PIBaseWdgGen* mBWdg;
  bool clip;

  list<DrwBWId>  mBWdgList;
  bool mDndfg;
  
};


#endif
