#include <stdio.h>
#include "pistlist.h"

 
/* --Methode-- */
PIStarList::PIStarList(StarList* stl, bool ad, int ayud)
: PIScDrawer(), mStL(stl)
{
  mAdDO = ad;   
  mAYdir = ayud;  
  if (stl == NULL) return;
  SetFluxLimits(1., -1.);
  SetXYLimits(1., -1., 1., -1.);
}

PIStarList::~PIStarList()
{
  if (mAdDO && mStL)  delete mStL;
}

/* --Methode-- */
void  PIStarList::SetFluxLimits(float fmin, float fmax, int nl, int msz0, bool refr)
{
  if (!mStL)  return;  
  if (fmin < fmax)  { mFmin = fmin;  mFmax = fmax; }
  else mStL->CalcFluxLimits(mFmin, mFmax);
  if (mFmin < 1.e-10)  mFmin = 1.e-10;
  if (mFmax < mFmin)  mFmax = 1.5*mFmin;
  mDLgF = log10((double)mFmax/(double)mFmin);
  mF0 = mFmin;
  if (nl < 1)  nl = 1;
  if (nl > 20)  nl = 20;
  mNLev = nl;  
  if (msz0 < 0)  msz0 = 0;
  if (msz0 > 10)  msz0 = 10; 
  mMSz0 = msz0;
  if (refr)  Refresh();
  return;
}

/* --Methode-- */
void  PIStarList::SetXYLimits(float xmin, float xmax, float ymin, float ymax, bool dfv, bool refr)
{
  if (!mStL)  return;  
  if ((xmin < xmax) && (ymin < ymax)) {
    mXMin = xmin; mXMax = xmax; mYMin = ymin; mYMax = ymax; 
    }
  else {
    double x1, x2, y1, y2;
    mStL->CalcXYLimits(x1, x2, y1, y2);
    mXMin = (float)x1; mXMax = (float)x2; mYMin = (float)y1; mYMax = (float)y2; 
    }
  mDspFV = dfv;
  if (refr)  Refresh();
  return;    
}  


/* --Methode-- */
void PIStarList::UpdateSize()
{
  if (!mStL) return;
  if (!mDrawer) return;
  if (mDrawer->LimitsFixed()) return;

  // Commencer par trouver nos limites
  float dx, dy;
  
  dx = 0.02*(mXMax-mXMin);
  dy = 0.02*(mYMax-mYMin);
  
  if (mDrawWdg) 
    mDrawWdg->SetLimits(mXMin-dx, mXMax+dx, mYMin-dy, mYMax+dy, kAxeDirLtoR, mAYdir); 
  else 
    mDrawer->SetLimits(mXMin-dx, mXMax+dx, mYMin-dy, mYMax+dy, false, mAYdir); 

  mDrawer->SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


/* --Methode-- */
void PIStarList::Draw(double xmin, double ymin, double xmax, double ymax)
{
BStar *sti;
float xp,yp,flx;
int sz,ixp, iyp;
char buff[128];
int nok, nl2;

if (!mStL) return;
if (!mDrawer) return;

mDrawer->SelFont();
nok = 0;  nl2 = mNLev*2-1;
for (int i=0; i<mStL->NbStars(); i++) {
  sti = mStL->Star(i);
  if ( !(sti->Nice(BStar::flagOK)) )  continue;
  flx = sti->Flux();
  if ( (flx < mFmin) || (flx > mFmax) )  continue;
  xp = sti->PosX();   yp = sti->PosY();
  if ( (xp < mXMin) || (xp > mXMax) || (yp < mYMin) || (yp > mYMax) )  continue;
  if ( (xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax) )  continue;
  nok++;
  sz = (int)((log10((double)flx/mF0))/mDLgF*(double)nl2-0.01) + mMSz0;
  if (sz < 2)  mDrawer->SelMarker(sz, PI_DotMarker);
  else mDrawer->SelMarker(sz, PI_FCircleMarker);
  mDrawer->DrawMarker((double)xp,(double)yp ); 
  if (mDspFV) {  
    sprintf(buff," F=%g", flx);
    mDrawer->Sc2Local(xp, yp, ixp, iyp);
    mDrawer->DrawString( ixp+sz/2+1, iyp-4, buff);
    } 
  }

if (!MainScDrawer()) return;
if (!mDrawWdg)  return;

sprintf(buff, "StarList:  NbStars= %d  NDisp= %d", (int)mStL->NbStars(), nok);
mDrawWdg->DrawString(15,15,buff);
sprintf(buff, "FMin= %g  FMax= %g Nl= %d Sz0= %d", mFmin, mFmax, mNLev, mMSz0);
mDrawWdg->DrawString(15,30,buff);

}

