// gondolageom.h
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#ifndef GONDOLAGEOM_H
#define GONDOLAGEOM_H

class GondolaGeom {
public:
  GondolaGeom();
  
  void setEarthPos(double lon, double lat);
  void setTSid(double ts);
  void setPendulation(double azimuth, double ampl);
  
  // Set orientation through SST
  void addStar(double deltasn, double az, double elv, double diod);
  int solveStars();
  
  void getPointing(double elv, double az, double& trueElv, double& trueAz);
  void getSkyPointing(double elv, double az, double& ra, double& dec);
  
  double getAzimutBolo(int ibolo); // ibolo, comme dans les TOI
  double getElvBolo(int ibolo);
  double getAlphaBolo(int ibolo);
  double getDeltaBolo(int ibolo);
  double getAzimutCenter();
  double getElvCenter();
  double getAlphaCenter();
  double getDeltaCenter();
  double getAzimutSST(); // diode 0
  double getElvSST();
  double getAlphaSST();
  double getDeltaSST();
  double getAzimutAxis();
  double getElvAxis();
  double getAlphaAxis();
  double getDeltaAxis();


// Geometry, "elevation" means if gondola is vertical
  static double elevFPC;    // degrees
  static double azFPC;      // degrees, relative to SST alignment
  static double elevSST0;   // degrees
  static double sstPixelHeight;  // degrees
  
  static void getAltAzBolo(int ibolo, double& elv, double& az); // pure geom, 
     // azimuth relative to SST.
  
protected:

  double lon; // degrees  +=EST
  double lat; // degrees  +=NORD
  double ts;  // secondes 
  
  double azPend;
  double angPend;
  
  double azimut; // horizontal, for SST
  
  long nstars;
  double saz,staz,st,st2;
  double az0;
};



#endif
