// This may look like C code, but it is really -*- C++ -*-
//  Adaptateurs pour TMatrix TVector du package Sophya
//                             R. Ansari  1/99
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PITVMAAD_H_SEEN
#define PITVMAAD_H_SEEN

#include "machdefs.h"
#include <math.h>
#include "parradapter.h"

#include "tmatrix.h"
#include "tvector.h"


// Adaptateur de vecteurs SOPHYA a P1DArrayAdapter
template <class T> 
class POTVectorAdapter : public P1DArrayAdapter {
public :
		  POTVectorAdapter(TVector<T>* v, bool ad=false) 
		        : P1DArrayAdapter(v->NElts())
	     			{ aDel = ad; mVec = v; }
  virtual         ~POTVectorAdapter()
				{ if (aDel) delete mVec; }
  virtual double  Value(int i)
				{ return((*mVec)(i)); }

protected:
  bool aDel;
  TVector<T>* mVec;
};

typedef POTVectorAdapter<r_8> POVectorAdapter;

double POTVectorAdapter< complex<float> >::Value(int i)
{
double re,im;
re = (*mVec)(i).real();
im = (*mVec)(i).imag();
return(sqrt(re*re+im*im));
}

double POTVectorAdapter< complex<double> >::Value(int i)
{
double re,im;
re = (*mVec)(i).real();
im = (*mVec)(i).imag();
return(sqrt(re*re+im*im));
}

// Adaptateur de matrice SOPHYA a P2DArrayAdapter
// Attention MatrixAdapter(X=Colonne, Y= Row) = Matrix(row, col)  
template <class T> 
class POTMatrixAdapter :  public P2DArrayAdapter {
public :
                  POTMatrixAdapter(TMatrix<T>* mtx, bool ad=false)
			: P2DArrayAdapter(mtx->NCols(), mtx->NRows())
			{ aDel = ad; mMtx = mtx; }
  virtual         ~POTMatrixAdapter()
			{ if (aDel)  delete mMtx; }
  virtual double  Value(int ix, int iy)
			{ return((double)(*mMtx)(iy, ix)); }

protected:
  bool aDel;
  TMatrix<T>* mMtx;
};

typedef POTMatrixAdapter<r_8> POMatrixAdapter;

double POTMatrixAdapter< complex<float> >::Value(int ix, int iy)
{
double re,im;
re = (*mMtx)(iy, ix).real();
im = (*mMtx)(iy, ix).imag();
return(sqrt(re*re+im*im));
}

double POTMatrixAdapter< complex<double> >::Value(int ix, int iy)
{
double re,im;
re = (*mMtx)(iy, ix).real();
im = (*mMtx)(iy, ix).imag();
return(sqrt(re*re+im*im));
}
#endif
