#include<stdio.h>

#include "pimenux.h"

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>

/************* PIMenuX ************/


// Fonction prive (CallBack)
static void menub_action(Widget w, XtPointer *usd, XtPointer *calld);

/* Nouvelle-Fonction */
void  menub_action(Widget w, XtPointer *usd, XtPointer *calld)
{
PIMenuX *pim;
_pimxit_ *cusd;

cusd = ( _pimxit_ *)usd ;
pim = (PIMenuX *) (cusd->pmen);

// pim->Unmanage();
pim->Send(cusd->msg, (void *)pim->ItemNameWdg(cusd->itb).c_str());
#ifdef DEBUG_PIMenuX
printf("%%%Debug_menub_action: Msg= %d  \n", (int)cusd->msg);
#endif
return;
}

#define NBITEMB  10

/* --Methode-- */
PIMenuX::PIMenuX(PIMsgHandler *par, char *nom, PIMenuType pdpu) 
: PIMenuGen(par, nom, pdpu)
{
mNItem = 0;  mNItemMax = NBITEMB; 
mBut = new _pimxit_[mNItemMax];

if (pdpu == k_PopupMenu)
  XtWdg() = XmCreatePopupMenu( PIXtTopWdg(), nom, NULL, 0); 
else 
  XtWdg() = XmCreatePulldownMenu( PIXtTopWdg(), nom, NULL, 0); 

wmis == k_wmi_normal ;
stmng = 0;
}

/* --Methode-- */
PIMenuX::~PIMenuX()
{
for(int i=0; i<mNItem; i++)
  XtDestroyWidget(mBut[i].itb);
delete[] mBut ;
}


/* --Methode-- */
void PIMenuX::AppendItem(char* nom, long msg)
{
AddItem(nom, msg, false);
}

/* --Methode-- */
void PIMenuX::DeleteItem(char *nom)
{
string s(nom);

for(int i=0; i<mNItem; i++)
  if (ItemName(i) == s)  
    { DeleteItemNum(i);  break; }

return;
}

/* --Methode-- */
void PIMenuX::DeleteItemMsg(long msg)
{
for(int i=0; i<mNItem; i++)
  if (mBut[i].msg == msg)  
    { DeleteItemNum(i);  break; }

return;
}


/* --Methode-- */
void PIMenuX::DeleteItemNum(int n)
{
if ((n < 0) || (n >= mNItem))  return;
XtDestroyWidget(mBut[n].itb);
for(int i=n; i<mNItem-1; i++)  
  { 
  String cbckn;
  if (mBut[i+1].togg)  cbckn = XmNvalueChangedCallback;
  else cbckn = XmNactivateCallback;
  XtRemoveCallback(mBut[i+1].itb, cbckn, 
                   menub_action, (XtPointer)(mBut+i+1));
  mBut[i] = mBut[i+1];
  XtAddCallback(mBut[i].itb, cbckn, 
                menub_action, (XtPointer)(mBut+i));
  }
mNItem--;
}


/* --Methode-- */
void PIMenuX::CheckItem(char *nom, bool st)
{
string s(nom);

for(int i=0; i<mNItem; i++)
  if (ItemName(i) == s)  
    { CheckItemNum(i, st);  break; }

return;
}

/* --Methode-- */
void PIMenuX::CheckItemMsg(long msg, bool st)
{
for(int i=0; i<mNItem; i++)
  if (mBut[i].msg == msg)  
    { CheckItemNum(i, st);  break; }

return;
}

/* --Methode-- */
void PIMenuX::CheckItemNum(int n, bool st)
{
printf("PIMenuX::CheckItemNum(%d,bool) Error/ Not yet implemented \n", n);
return;
}

/* --Methode-- */
void PIMenuX::Show()
{
Manage();
}

/* --Methode-- */
void PIMenuX::Hide()
{
Unmanage();
}



/* --Methode-- */
string PIMenuX::ItemName(int n)
{
if ( (n < 0) || (n >= mNItem))  return("");
return (ItemNameWdg(mBut[n].itb));
}


/* --Methode-- */
string PIMenuX::ItemNameWdg(SysDWdg itw)
{
string s;
char *buff;
XmString xmstr;
Arg warg[2];

XtSetArg(warg[0], XmNlabelString, &xmstr);
XtGetValues(itw, warg, 1);
if (xmstr)
  {
  XmStringGetLtoR(xmstr, XmSTRING_DEFAULT_CHARSET, &buff);
  s=buff;
  XmStringFree(xmstr);
  }
else s = "";

return(s);
}


/* --Methode-- */
long PIMenuX::ItemMsg(int n)
{
if ( (n < 0) || (n >= mNItem))  return(0);
else return(mBut[n].msg);
}



/* --Methode-- */
int PIMenuX::GetNumItem(char *nom)
{
string s(nom);

for(int i=0; i<mNItem; i++)
  if (ItemName(i) == s)  return(i);
return(-1);
}

/* --Methode-- */
int PIMenuX::GetNumItemMsg(long msg)
{
for(int i=0; i<mNItem; i++)
  if (mBut[i].msg == msg)   return(i);  
return(-1);
}

/* --Methode-- */
SysDWdg PIMenuX::GetItemWdg(int n)
{
if ((n<0) || (n>=mNItem))  return(NULL);
else return(mBut[n].itb);
}


/* --Methode-- */
void PIMenuX::AddItem(char* nom, long msg, bool tog)
{
_pimxit_ *buto;
SysDWdgClass wdgcl;
String cbckn;


if (mNItem >= mNItemMax)
  {
  buto = mBut;
  mNItemMax += NBITEMB;
  mBut = new _pimxit_[mNItemMax];
  for(int i=0; i<mNItem; i++)   
    {
    if (buto[i].togg)  cbckn = XmNvalueChangedCallback;
    else cbckn = XmNactivateCallback;
    XtRemoveCallback(buto[i].itb, cbckn, 
                     menub_action, (XtPointer)(buto+i));
    mBut[i] = buto[i];
    XtAddCallback(mBut[i].itb, cbckn, 
                  menub_action, (XtPointer)(mBut+i));
    }

  delete[] buto;
  }

if (tog)
  {
  cbckn = XmNvalueChangedCallback;
  wdgcl = xmToggleButtonWidgetClass;
  }
else 
  {
  cbckn = XmNactivateCallback;
  wdgcl = xmPushButtonWidgetClass;
  }

mBut[mNItem].itb = XtCreateManagedWidget(nom, wdgcl, this->XtWdg(), NULL, 0) ; 
XtAddCallback(mBut[mNItem].itb, cbckn, 
              menub_action, (XtPointer)(mBut+mNItem));
#ifdef DEBUG_PIMenuX
printf("DBG>> %d (%d) %lx \n", mNItem, mNItemMax, (long)(mBut+mNItem));
#endif
mBut[mNItem].pmen = this;
mBut[mNItem].msg = msg;
mBut[mNItem].togg = tog;
mNItem++;
return;
}



/* --Methode-- */
void PIMenuX::Check()
{
printf("#Debug_CHECK: %d %d %d %d \n",XSize(), YSize(), XPos(), YPos() );  
for(int i=0; i<mNItem; i++)
  printf("##Debug_CHECK: %d %d %ld %lx %lx %lx \n", i, (int)mBut[i].togg, 
         (long) mBut[i].msg, (long) mBut[i].itb, 
         (long) mBut[i].pmen, long (mBut+i));
return;
}

/* --Methode-- A virer 
void PIMenuX::AppendCheckItem(char* nom, long msg)
{
AddItem(nom, msg, true);
}
*/

/* --Methode--   A virer 
void PIMenuX::SetItem(int n, bool st) 
{
if ((n < 0) || (n >= mNItem))  return;
if (mBut[n].togg)  // C'est un toggle Bouton !
  {
  Arg  wargs[2];
  int n=0;
  if (st)  XtSetArg(wargs[n],XmNset,TRUE);  
  else XtSetArg(wargs[n],XmNset,FALSE);  
  n++;
  XtSetValues(mBut[n].itb, wargs, n);  
  }
return;
}
*/


/* --Methode-- */
PIPUMenuX::PIPUMenuX(PIMsgHandler* par, char* nom)
: PIMenuX(par, nom, k_PopupMenu)
{
}

/* --Methode-- */
PIPUMenuX::~PIPUMenuX()
{
}

void PIPUMenuX::Show()
{
XButtonEvent evt;

evt.type = ButtonPress;
evt.serial = 55998877;
evt.send_event = False;
evt.display = PIXDisplay();
evt.window = XtWindow(PIXtTopWdg());
evt.root = DefaultRootWindow(evt.display);
evt.same_screen = XQueryPointer(evt.display, evt.window, &(evt.root), 
                    &(evt.subwindow), &(evt.x_root), &(evt.y_root), 
                    &(evt.x), &(evt.y), &(evt.state));
 
#ifdef DEBUG_PIMenuX
printf("XXDbg_Show : %d %d %d - %d %d \n", (int)evt.same_screen, 
       (int)evt.x_root, (int)evt.y_root, (int)evt.x, (int)evt.y);
#endif

if (evt.same_screen) XmMenuPosition(XtWdg(), &evt);
Manage();     
}

/* --Methode-- */
PIPDMenuX::PIPDMenuX(PIMsgHandler* par, char* nom)
: PIMenuX(par, nom, k_PulldownMenu)
{
}

/* --Methode-- */
PIPDMenuX::~PIPDMenuX()
{
}

