/* Classe pour enrobage generique des widgets Xt, Mac, etc  */
/*                                    Reza 10/95            */

#ifndef PIWDG_H_SEEN
#define PIWDG_H_SEEN

#include <bool.h>
#include <string>

#include "pimsghandler.h"

class PIContainerGen;
class PIWdgGen : public PIMsgHandler
{
public:
  enum {ClassId = 100};

                         PIWdgGen(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual               ~PIWdgGen();
  virtual void		 FinishCreate()=0; // apres avoir installe les sous-vues

  virtual long           kind() {return ClassId; }

//  string               kindstr();

  inline void         	 SetUserData( void * p, int fg = 0) {pdata=p; flag=fg; }
  inline void*       	 UserData() { return (pdata); };
  inline void const* 	 UserData() const { return (pdata); };
  inline int         	 UserFlag() { return(flag); };

  inline void            SetMsg(long msg = 0) { myMsg = msg; }
  inline long            Msg() { return(myMsg); }

  virtual void           SetSize(int sx, int sy)=0;
  virtual void           SetPos(int px, int py)=0;
  virtual void           SetBorderWidth(int bw)=0;
  virtual void           SetLabel(string const&) {}
  virtual void           SetBinding(bool left, bool top, bool right, bool bottom)=0;

  virtual int            XSize()=0;
  virtual int            YSize()=0;
  virtual int            XPos()=0;
  virtual int            YPos()=0;

  virtual string         Nom()=0;

protected:
  PIContainerGen        *parent;
  long                  myMsg;

private:
  int flag;
  void * pdata;
};


  

#endif/* PIWDG_H_SEEN */
