#include<stdio.h>

#include "pimenux.h"

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>

/************* PIMenuX ************/

// Quand on cree les menus comme fils du Top-Widget, ca rentre en 
// conflit avec certaains Window-Manager ...
// La fonction suivante permet de bypasser ce probleme- Le createur d'application
// X doit donc appeler la fonction ci-dessous pour initialiser menuXTopWdg
//                                               Reza /411/97
static SysDWdg menuXTopWdg = NULL;
void SetTopWdgForMenuX(SysDWdg mtw) {
  menuXTopWdg = mtw;
}

// Pour ces sal... de XmString  (ds piwdgx.cc)
int CStrFrXmStr(XmString xms, char* buff, int nmx);


// Fonction prive (CallBack)
static void menub_action(Widget w, XtPointer *usd, XtPointer *calld);

/* Nouvelle-Fonction */
void  menub_action(Widget /*w*/, XtPointer *usd, XtPointer* /*calld*/)
{
PIMenuX *pim;
_pimxit_ *cusd;

cusd = ( _pimxit_ *)usd ;
pim = (PIMenuX *) (cusd->pmen);

// pim->Hide();
pim->Send(cusd->msg, PIMsg_Click, (void *)pim->ItemNameWdg(cusd->itb));
#ifdef DEBUG_PIMenuX
printf("%%%Debug_menub_action: Msg= %d  %lx\n", (int)cusd->msg, (long)pim);
#endif
return;
}

#define NBITEMB  10

/* --Methode-- */
PIMenuX::PIMenuX(PIMsgHandler *par, char *nom, PIMenuType pdpu) 
: PIMenuGen(par, nom, pdpu)
{
mNItem = 0;  mNItemMax = NBITEMB; 
mBut = new _pimxit_[mNItemMax];

SysDWdg tw= menuXTopWdg;
if (tw == NULL) tw = PIXtTopWdg();

if (pdpu == k_PopupMenu)
  XtWdg() = XmCreatePopupMenu( tw, nom, NULL, 0); 
else 
  XtWdg() = XmCreatePulldownMenu( tw, nom, NULL, 0); 

wmis = k_wmi_normal ;
stmng = 0;
}

/* --Methode-- */
PIMenuX::~PIMenuX()
{
for(int i=0; i<mNItem; i++)
  XtDestroyWidget(mBut[i].itb);
delete[] mBut ;
}


/* --Methode-- */
void PIMenuX::AppendItem(char* nom, PIMessage msg, char* sc)
{
AddItem(nom, msg, false, sc);
}

/* --Methode-- */
void PIMenuX::DeleteItem(char *nom)
{

for(int i=0; i<mNItem; i++)
  if (strcmp(ItemName(i), nom) == 0)  
    { DeleteItemNum(i);  break; }

return;
}

/* --Methode-- */
void PIMenuX::DeleteItemMsg(PIMessage msg)
{
for(int i=0; i<mNItem; i++)
  if (mBut[i].msg == msg)  
    { DeleteItemNum(i);  break; }

return;
}


/* --Methode-- */
void PIMenuX::DeleteItemNum(int n)
{
if ((n < 0) || (n >= mNItem))  return;
XtDestroyWidget(mBut[n].itb);
for(int i=n; i<mNItem-1; i++)  
  { 
  String cbckn;
  if (mBut[i+1].togg)  cbckn = XmNvalueChangedCallback;
  else cbckn = XmNactivateCallback;
  XtRemoveCallback(mBut[i+1].itb, cbckn, 
                   (XtCallbackProc)menub_action, (XtPointer)(mBut+i+1));
  mBut[i] = mBut[i+1];
  XtAddCallback(mBut[i].itb, cbckn, 
                (XtCallbackProc)menub_action, (XtPointer)(mBut+i));
  }
mNItem--;
}


/* --Methode-- */
void PIMenuX::CheckItem(char *nom, bool st)
{

for(int i=0; i<mNItem; i++)
  if (strcmp(ItemName(i), nom) == 0)  
    { CheckItemNum(i, st);  break; }

return;
}

/* --Methode-- */
void PIMenuX::CheckItemMsg(PIMessage msg, bool st)
{
for(int i=0; i<mNItem; i++)
  if (mBut[i].msg == msg)  
    { CheckItemNum(i, st);  break; }

return;
}

/* --Methode-- */
void PIMenuX::CheckItemNum(int n, bool /*st*/)
{
printf("PIMenuX::CheckItemNum(%d,bool) Error/ Not yet implemented \n", n);
return;
}

/* --Methode-- */
void PIMenuX::Show()
{
Manage();
}

/* --Methode-- */
void PIMenuX::Show(PIWdg* /*w*/, int /*px*/, int /*py*/)
{
Manage();
}


/* --Methode-- */
void PIMenuX::Hide()
{
// UnManage();
}



/* --Methode-- */
char* PIMenuX::ItemName(int n)
{
if ( (n < 0) || (n >= mNItem))  { mSItem[0] = '\0'; return(mSItem); }
else return (ItemNameWdg(mBut[n].itb));
}


/* --Methode-- */
char* PIMenuX::ItemNameWdg(SysDWdg itw)
{
XmString xmstr;
Arg warg[2];

XtSetArg(warg[0], XmNlabelString, &xmstr);
XtGetValues(itw, warg, 1);
if (xmstr)
  {
  CStrFrXmStr(xmstr, mSItem, 96);
  XmStringFree(xmstr);
  }
else mSItem[0] = '\0';

return(mSItem);
}


/* --Methode-- */
PIMessage PIMenuX::ItemMsg(int n)
{
if ( (n < 0) || (n >= mNItem))  return(0);
else return(mBut[n].msg);
}



/* --Methode-- */
int PIMenuX::GetNumItem(char *nom)
{

for(int i=0; i<mNItem; i++)
  if (strcmp(ItemName(i),nom) == 0)  return(i);
return(-1);
}

/* --Methode-- */
int PIMenuX::GetNumItemMsg(PIMessage msg)
{
for(int i=0; i<mNItem; i++)
  if (mBut[i].msg == msg)   return(i);  
return(-1);
}

/* --Methode-- */
SysDWdg PIMenuX::GetItemWdg(int n)
{
if ((n<0) || (n>=mNItem))  return(NULL);
else return(mBut[n].itb);
}


/* --Methode-- */
void PIMenuX::AddItem(char* nom, PIMessage msg, bool tog, char* sc)
{
_pimxit_ *buto;
SysDWdgClass wdgcl;
String cbckn;


if (mNItem >= mNItemMax)
  {
  buto = mBut;
  mNItemMax += NBITEMB;
  mBut = new _pimxit_[mNItemMax];
  for(int i=0; i<mNItem; i++)   
    {
    if (buto[i].togg)  cbckn = XmNvalueChangedCallback;
    else cbckn = XmNactivateCallback;
    XtRemoveCallback(buto[i].itb, cbckn, 
                     (XtCallbackProc)menub_action, (XtPointer)(buto+i));
    mBut[i] = buto[i];
    XtAddCallback(mBut[i].itb, cbckn, 
                 (XtCallbackProc) menub_action, (XtPointer)(mBut+i));
    }

  delete[] buto;
  }

if (tog)
  {
  cbckn = XmNvalueChangedCallback;
  wdgcl = xmToggleButtonWidgetClass;
  }
else 
  {
  cbckn = XmNactivateCallback;
  wdgcl = xmPushButtonWidgetClass;
  }

mBut[mNItem].itb = XtCreateManagedWidget(nom, wdgcl, this->XtWdg(), NULL, 0) ; 
XtAddCallback(mBut[mNItem].itb, cbckn, 
              (XtCallbackProc)menub_action, (XtPointer)(mBut+mNItem));
if (sc)  // Raccourci clavier 
  {
  char acc[16];
  int n=0;
  Arg warg[2];
  XmString xmstr;

  sprintf(acc,"Ctrl/%c", sc[0]);
  xmstr = XmStringLtoRCreate(acc, XmSTRING_DEFAULT_CHARSET);
  XtSetArg(warg[n], XmNacceleratorText, xmstr); n++;
  sprintf(acc,"Ctrl<Key>%c", sc[0]);
  XtSetArg(warg[n], XmNaccelerator, acc); n++;
  XtSetValues(mBut[mNItem].itb, warg, n);  
  XmStringFree(xmstr);
  }

#ifdef DEBUG_PIMenuX
printf("DBG>> %d (%d) %lx \n", mNItem, mNItemMax, (long)(mBut+mNItem));
#endif
mBut[mNItem].pmen = this;
mBut[mNItem].msg = msg;
mBut[mNItem].togg = tog;
mNItem++;
return;
}



/* --Methode-- */
void PIMenuX::Check()
{
printf("#Debug_CHECK: %d %d %d %d \n",XSize(), YSize(), XPos(), YPos() );  
for(int i=0; i<mNItem; i++)
  printf("##Debug_CHECK: %d %d %ld %lx %lx %lx \n", i, (int)mBut[i].togg, 
         (long) mBut[i].msg, (long) mBut[i].itb, 
         (long) mBut[i].pmen, long (mBut+i));
return;
}

/* --Methode-- A virer 
void PIMenuX::AppendCheckItem(char* nom, PIMessage msg)
{
AddItem(nom, msg, true);
}
*/

/* --Methode--   A virer 
void PIMenuX::SetItem(int n, bool st) 
{
if ((n < 0) || (n >= mNItem))  return;
if (mBut[n].togg)  // C'est un toggle Bouton !
  {
  Arg  wargs[2];
  int n=0;
  if (st)  XtSetArg(wargs[n],XmNset,TRUE);  
  else XtSetArg(wargs[n],XmNset,FALSE);  
  n++;
  XtSetValues(mBut[n].itb, wargs, n);  
  }
return;
}
*/


/* --Methode-- */
PIPUMenuX::PIPUMenuX(PIMsgHandler* par, char* nom)
: PIMenuX(par, nom, k_PopupMenu)
{
}

/* --Methode-- */
PIPUMenuX::~PIPUMenuX()
{
}

void PIPUMenuX::Show()
{
// XEvent  mevt;
XButtonEvent evt;

// XPeekEvent(PIXDisplay(), &mevt);
// evt = mevt.xbutton; 
evt.type = ButtonPress;
evt.display = PIXDisplay();
evt.window = XtWindow(PIXtTopWdg());
evt.root = DefaultRootWindow(evt.display);
evt.serial = 8866559909;
evt.send_event = False;
evt.same_screen = XQueryPointer(evt.display, evt.window, &(evt.root), 
                    &(evt.subwindow), &(evt.x_root), &(evt.y_root), 
                    &(evt.x), &(evt.y), &(evt.state));
 
#ifdef DEBUG_PIMenuX
printf("XXDbg_Show : %d %d %d - %d %d \n", (int)evt.same_screen, 
       (int)evt.x_root, (int)evt.y_root, (int)evt.x, (int)evt.y);
#endif

if (evt.same_screen) XmMenuPosition(XtWdg(), &evt);
Manage();     
}

/* --Methode-- */
void PIPUMenuX::Show(PIWdg *w, int px, int py)
{
// This method should only be used by a button press ...
int xr, yr;
Window cw, sw, rw;
SysDWdg xtw;
Display *dsp;
XButtonEvent evt;

xtw =  w->XtWdg();
dsp = XtDisplay(xtw);
sw = XtWindow(xtw);
rw = DefaultRootWindow(dsp);
XTranslateCoordinates(dsp, sw, rw, px, py, &xr, &yr, &cw);

evt.type = ButtonPress;
evt.display = dsp;
evt.window = sw;
evt.root = rw;
evt.x_root = xr;
evt.y_root = yr; 
evt.x = px;
evt.y = py;
evt.serial = 8866559909;
evt.send_event = False;
evt.same_screen = True;
XmMenuPosition(XtWdg(), &evt);
// SetPos(xr, yr);
Manage();
return;    
}


/* --Methode-- */
PIPDMenuX::PIPDMenuX(PIMsgHandler* par, char* nom)
: PIMenuX(par, nom, k_PulldownMenu)
{
}

/* --Methode-- */
PIPDMenuX::~PIPDMenuX()
{
}


