#ifndef PIBWDGX_H_SEEN
#define PIBWDGX_H_SEEN

#include "pisysdep.h"
#include "pibwdggen.h"


class PIBaseWdgX : public PIBaseWdgGen
{

public:
// Les methodes ...

                  PIBaseWdgX(PIContainerGen *par, char *nom,
                             int sx=10, int sy=10, int px=0, int py=0);
  virtual         ~PIBaseWdgX();

  virtual void    FinishCreate(); // appele par la fenetre mere, apres XtRealize()

//  Trace graphiques
  virtual void   EraseWindow(int x0=0, int y0=0, int dx=0, int dy=0);
  virtual void   DrawString(int x, int y, char* s, int pos = 0);
  virtual void   DrawLine(int x1, int y1, int x2, int y2);
  virtual void   DrawBox(int x0, int y0, int dx, int dy);
  virtual void   DrawFBox(int x0, int y0, int dx, int dy);
  virtual void   DrawCircle(int x0, int y0, int r);
  virtual void   DrawFCircle(int x0, int y0, int r);
  virtual void   DrawPolygon(int *x, int *y, int n);  
  virtual void   DrawFPolygon(int *x, int *y, int n);  
  virtual void   DrawMarker(int x0, int y0);
  virtual void   DrawMarkers(int *x, int *y, int n);
  virtual void   DrawPixmap(int x, int y, unsigned char *pix, 
                            int sx, int sy, PIColorMap* cmap);

  virtual int    CalcStringWidth(char const* s);

// Modifications attributs graphiques
  virtual void   SelForeground(PIColors col=PI_Black);
  virtual void   SelBackground(PIColors col=PI_White);
  virtual void   SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void   SelFont(PIFontSize sz=PI_NormalSizeFont, 
                         PIFontAtt att=PI_RomanFont);
  virtual void   SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);
  virtual void   SelLine(PILineAtt att=PI_NormalLine);
  virtual void   SelPointerShape(PIPointer ptr=PI_ArrowPointer);
  virtual void   SelMarker(int msz, PIMarker mrk=PI_DotMarker);
  
// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(int x0, int y0, int dx, int dy);
  virtual void       ClearClipRectangle();

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PIFontAtt  GetFontAtt();
  virtual int        GetFontSize();
  virtual PILineAtt  GetLineAtt();
  virtual PIPointer  GetPointerShape();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();
  virtual int        GetFontHeight(int& asc, int& desc);

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();

//  Fonction qui doit etre appelee pour rafraichir (retracer) tout 
  virtual void   Refresh();

// Traitement des evenements   
  virtual void   Resize();
  virtual void   Draw();
  virtual void   Draw(int x0, int y0, int dx, int dy);

  virtual void   Enter();
  virtual void   Leave();  
  virtual void   But1Press(int x, int y);
  virtual void   But1Release(int x, int y);
  virtual void   But2Press(int x, int y);
  virtual void   But2Release(int x, int y);
  virtual void   But3Press(int x, int y);
  virtual void   But3Release(int x, int y);
  virtual void   Ptr1Move(int x, int y);
  virtual void   Ptr2Move(int x, int y);
  virtual void   Ptr3Move(int x, int y);
  virtual void   Keyboard(int key, PIKeyModifier kmod);

  inline  GC     DefGC() { return mDefGC; }

protected:

  void           Init();
  void           SelectFont(int isz, int jat);
//  Activation des evenements   
  void   ActivatePtrCross();
  void   ActivateButton(int bid);
  void   ActivateMove(int bid);
  void   ActivateKeyboard();

  GC mDefGC;
  PIColors  mFCol, mBCol;
  PIGOMode mGOm;
  PIPointer mPtrS;
  PIFontAtt mFAtt;
  PILineAtt mLAtt;
  int mFSize;
  XFontStruct *mFSt;
  PIMarker mMrk;
  int mMrkSz;
};

typedef PIBaseWdgX PIBaseWdg;

#endif /* PIBWDGX_H_SEEN */
