//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: nupower.cc,v 1.1.1.1 1999-11-19 16:34:32 ansari Exp $
//
// Description:
//      Aim of the class: To give the energy density for a nupower
//                        The unity used here is W/m^2/Hz/sr
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream.h>
#include <math.h>

#include "nupower.h"

//----------------
// Constructor --
//----------------
PowerLawSpectra::PowerLawSpectra(double a, double b, double nu0, double numin, double numax)
  : RadSpectra(numin, numax)
{
  _a = a;
  _b = b;
  _nu0 = nu0;
}


PowerLawSpectra::~PowerLawSpectra()
{
}

double
PowerLawSpectra::flux(double nu) const
{
  if ((nu < _numin) || (nu > _numax)) return(0.);
  else return(  _a * pow((nu-_nu0), _b) );
}

void
PowerLawSpectra::Print(ostream& os) const
{
  os << "PowerLawSpectra::Print f = a (nu-nu0)^b " << _a << "(nu-" << _nu0 
     << ") ^ " << _b << endl;
  os << " - Fmin,Fmax= " << minFreq() << "," << maxFreq() << endl;
  os << "MeanFreq= " << meanFreq() << "  Emission= " << flux(meanFreq()) << endl;
  os << "PeakFreq= " << peakFreq() << "  Emission= " << flux(peakFreq()) << endl;

}
