#include <iostream.h>
#include "blackbody.h"
#include "radspecvector.h"
#include "specrespvector.h"
#include "tvector.h"
// #include "szsource.h"
#include "squarefilt.h"
#include "trianglefilt.h"
int
main() 
{ 
  cout << "BlackBody!" << endl;
  BlackBody myBB;
  double freqmin =  10.;
  double freqmax = 100;
  double logIF = myBB.logIntegratedFlux(freqmin,freqmax);
  double IF    = myBB.integratedFlux(freqmin,freqmax);
  cout << "log   " << logIF << endl;
  cout << "nolog " << IF    << endl;
  cout << "min et max " << myBB.minFreq() << " :: " << myBB.maxFreq() << endl;
  cout << "full integration no log  " << myBB.integratedFlux() << endl;
  cout << "full integration log     " << myBB.logIntegratedFlux() << endl;

  /*
  cout << "SZSource " << endl;
  SzSource mySZ(1);
  double logSZ = mySZ.logIntegratedFlux(freqmin,freqmax);
  double SZ    = mySZ.integratedFlux(freqmin,freqmax);
  cout << "log   " << logSZ << endl;
  cout << "nolog " << SZ    << endl;
  cout << "min et max " << mySZ.minFreq() << " :: " << mySZ.maxFreq() << endl;
  cout << "full integration no log  " << mySZ.integratedFlux() << endl;
  cout << "full integration log     " << mySZ.logIntegratedFlux() << endl;
  */
  cout << "squareFilter " << endl;
  SquareFilter mySF(0,200);
  double logSF = mySF.logIntegratedSpect(freqmin,freqmax);
  double SF    = mySF.IntegratedSpect(freqmin,freqmax);
  cout << "log   " << logSF << endl;
  cout << "nolog " << SF    << endl;
  cout << "min et max " << mySF.minFreq() << " :: " << mySF.maxFreq() << endl;
  cout << "full integration no log  " << mySF.IntegratedSpect() << endl;
  cout << "full integration log     " << mySF.logIntegratedSpect() << endl;

  cout << "triangleFilter" << endl;
  TriangleFilter myTF(10,200,20,40);
  double logTF = myTF.logIntegratedSpect(10.,freqmax);
  double TF    = myTF.IntegratedSpect(10.,freqmax);
  cout << "log   " << logTF << endl;
  cout << "nolog " << TF    << endl;
  cout << "min et max " << myTF.minFreq() << " :: " << myTF.maxFreq() << endl;
  cout << "full integration no log  " << myTF.IntegratedSpect() << endl;
  cout << "full integration log     " << myTF.logIntegratedSpect() << endl;
  
  cout << "....Testing RadSpectraVec..." << endl;
  int maxVal = 10;
  Vector vecOfNu(maxVal);
  Vector vecOfFDeNu(maxVal);
  for (int i=0; i<maxVal; i++)
    {
      vecOfNu(i) = (double)i+30.;
      vecOfFDeNu(i) = 1.; //*(double)i+1;
      cout << "entry values  " <<  vecOfNu(i) << " " << vecOfFDeNu(i) << endl;
    }
  freqmin = 10.;
  freqmax = 19.;
  RadSpectraVec myRSV(vecOfNu, vecOfFDeNu);
  double RSV    = myRSV.integratedFlux(freqmin,freqmax);
 
  double logRSV = myRSV.logIntegratedFlux(freqmin,freqmax);
  cout << "nolog int " << RSV    << endl; 
  cout << "log int   " << logRSV << endl;
  cout << "min et max " << myRSV.minFreq() << " :: " << myRSV.maxFreq() << endl;
  cout << "full integration no log  " << myRSV.integratedFlux() << endl;
  cout << "full integration log     " << myRSV.logIntegratedFlux() << endl;

  cout << "....Testing SpecRespVec..." << endl;
  int SRVmaxVal = 100;
  Vector vecOfNuRSV(SRVmaxVal);
  Vector vecOfFDeNuRSV(SRVmaxVal);
  for (int i=0; i<SRVmaxVal; i++)
    {
      vecOfNuRSV(i) = (double)i+30.;
      vecOfFDeNuRSV(i) = 10*(double)i+1;
      //      cout << "entry values  " <<  vecOfNuRSV(i) << " " << vecOfFDeNuRSV(i) << endl;
    }
  freqmin = vecOfNuRSV(0);
  freqmax = vecOfNuRSV(SRVmaxVal-1);
  SpecRespVec mySRV(vecOfNuRSV, vecOfFDeNuRSV);
  double SRV    = mySRV.IntegratedSpect(freqmin,freqmax);
  double logSRV = mySRV.logIntegratedSpect(freqmin,freqmax);
  cout << "nolog " << SRV    << endl; 
  cout << "log   " << logSRV << endl;
  cout << "min et max " << mySRV.minFreq() << " :: " << mySRV.maxFreq() << endl;
  cout << "full integration no log " << mySRV.IntegratedSpect() << endl;
  cout << "full integration log    " << mySRV.logIntegratedSpect() << endl;
  
  cout << "----------------------------------------------------" << endl;
  cout << "...Testing filter and integrate !" << endl;

  cout << " BBSF nolog " << myBB.filteredIntegratedFlux(mySF,30.,100.) << endl;
  cout << " BBSF   log " << myBB.filteredLogIntFlux(mySF,30.,100.) << endl;
  cout << "full integration no log  " << myBB.integratedFlux(30.,100.) << endl;
  cout << "full integration log     " << myBB.logIntegratedFlux(30.,100.) << endl;
  cout << "SF" << endl;
  cout << "full integration no log  " << mySF.IntegratedSpect(30.,100.) << endl;
  cout << "full integration log     " << mySF.logIntegratedSpect(30.,100.) << endl;

  cout << " BBTF nolog " << myBB.filteredIntegratedFlux(myTF,30.,100.) << endl;
  cout << " BBTF   log " << myBB.filteredLogIntFlux(myTF,30.,100.) << endl;
  cout << "TF" << endl;
  cout << "full integration no log  " << myTF.IntegratedSpect(30.,100.) << endl;
  cout << "full integration log     " << myTF.logIntegratedSpect(30.,100.) << endl;

  /*
  cout << " SZSF nolog " << mySZ.filteredIntegratedFlux(mySF,30.,100.) << endl;
  cout << " SZSF  log " << mySZ.filteredLogIntFlux(mySF,30.,100.) << endl;
  cout << "full integration no log  " << mySZ.integratedFlux(30.,100.) << endl;
  cout << "full integration log     " << mySZ.logIntegratedFlux(30.,100.) << endl;

  cout << " SZTF nolog " << mySZ.filteredIntegratedFlux(myTF,30.,100.) << endl;
  cout << " SZTF   log " << mySZ.filteredLogIntFlux(myTF,30.,100.) << endl;
			   */
  cout << "********" << endl;
  cout << " RSVSF nolog " << myRSV.filteredIntegratedFlux(mySF,30.,100.) << endl;
  cout << " RSVSF   log " << myRSV.filteredLogIntFlux(mySF,30.,100.) << endl;
  cout << "full integration no log  " << myRSV.integratedFlux(30.,100.) << endl;
  cout << "full integration log     " << myRSV.logIntegratedFlux(30.,100.) << endl;

  cout << " RSVTF nolog " << myRSV.filteredIntegratedFlux(myTF,30.,100.) << endl;
  cout << " RSVTF   log " << myRSV.filteredLogIntFlux(myTF,30.,100.) << endl;
  

  return 1;
} 
