// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: radspec.h,v 1.1.1.1 1999-11-19 16:34:32 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef RADSPEC_H_SEEN
#define RADSPEC_H_SEEN

#include "machdefs.h"
#include <iostream.h>

#include "specresp.h"

//              ---------------------
//              -- Class Interface --
//              ---------------------

// ***IMPORTANT*** All frequencies are expressed in GHz  (10^9 Hz)
//                 and flux in Watt/m^2/sr

class RadSpectra
{

public:
  //Constructor
  RadSpectra (double numin=0., double numax=9.e49);

  // destructor
  virtual ~RadSpectra();

  //
  //  Member Functions
  //

  //  The flux() function is virtual: 
  //  It computes the flux per units of W/m^2/Hz/st
  // implemented in the subclasses
  virtual double flux(double nu) const =0;
  inline double operator() (double nu) const { return(flux(nu)); }

  virtual double minFreq() const;
  virtual double maxFreq() const;
  virtual double meanFreq() const;
  virtual double peakFreq() const;

  // For changing the min/max frequency
  virtual void	 setMinMaxFreq(double numin, double numax);

  // The IntegratedFlux() function
  // integrates the flux function between two frequencies: 
  // numin and numax (in GHz)
  virtual double integratedFlux( double numin, double numax) const ;
  virtual double logIntegratedFlux( double numin, double numax) const ;

  // same but integrated over the full spectrum of frequencies
  virtual  double integratedFlux() const ;
  virtual  double logIntegratedFlux() const ;
  
  // filteredIntegratedFlux integrates the flux function while
  // taking into account the spectralResponse of a filter
  virtual double filteredIntegratedFlux(SpectralResponse const & filter, 
					double numin, double numax) const ;
  virtual double filteredLogIntFlux(SpectralResponse const & filter, 
					double numin, double numax) const ;

  // same but integrates over the filter's frequency band
  virtual double filteredIntegratedFlux(SpectralResponse const & filter);
  virtual double filteredLogIntFlux(SpectralResponse const & filter);

  virtual void      Print(ostream& os)  const;

protected:
  double _numin;
  double _numax;
};

// Definition de l'operateur <<
inline ostream& operator << (ostream& s,  RadSpectra const & rs)
  {  rs.Print(s);  return(s);  }


#endif
