//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: blackbody.cc,v 1.1.1.1 1999-11-19 16:34:32 ansari Exp $
//
// Description:
//      Aim of the class: To give the energy density for a blackbody
//                        The unity used here is W/m^2/Hz/sr
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream.h>
#include <math.h>
#include "blackbody.h"

//----------------
// Constructor --
//----------------
BlackBody::BlackBody(double temperature)
  : RadSpectra(0., 10000.)
{
  _temperature = temperature;
}


BlackBody::~BlackBody()
{
}


double
BlackBody::flux(double nu) const
{
  if(nu < -1.e99) nu = -1.e99;
  if(nu > 1.e99) nu = 1.e99;
  double temperature = getTemperature();
  if(nu==0.) return 0.;
  double hpl = ConvTools::hpl;
  double cel = ConvTools::cel;
  double kb  = ConvTools::kb;
  double puiss1 = nu*pow(10,9);
  if(puiss1 >  1.e99)   puiss1=1.e99;
  if(puiss1 < -1.e99)   puiss1=-1.e99;
  double puiss2 = hpl*nu*pow(10,9)/(kb*temperature);
  if(puiss2 >  1.e99)   puiss2=1.e99;
  if(puiss2 < -1.e99)   puiss2=-1.e99;
  
  double result=
   (2*hpl* pow( puiss1 ,3))/( pow(cel,2)*(exp(puiss2)-1));
  return result;
}

void
BlackBody::Print(ostream& os) const
{
  os << "BlackBody::Print Temp= " << getTemperature() 
     << " - Fmin,Fmax= " << minFreq() << "," << maxFreq() << endl;
  os << "MeanFreq= " << meanFreq() << "  Emission= " << flux(meanFreq()) << endl;
  os << "PeakFreq= " << peakFreq() << "  Emission= " << flux(peakFreq()) << endl;

}
