#ifndef FITSIOSERVER_SEEN
#define FITSIOSERVER_SEEN

#include "fitsio.h" 
#include "tvector.h"
#include "sphericalmap.h"
#include "spheregorski.h"
#include "localmap.h"
#include "ntuple.h"
#include "outilsinit.h"
#include "cimage.h"
#include "dvlist.h"

#define LEN_KEYWORD 9

class FitsIoServer 
{

public :

  FitsIoServer() : FITS_tab_typ_(0),i_4tab_(NULL),r_4tab_(NULL),r_8tab_(NULL) {;}
 ~FitsIoServer()
   {
     if (i_4tab_ != NULL) delete [] i_4tab_;
     if (r_4tab_ != NULL) delete [] r_4tab_;
     if (r_8tab_ != NULL) delete [] r_8tab_;
   }

 void load(TMatrix<double>& mat, char flnm[]);
 void load(TMatrix<float>& mat, char flnm[]);
 void load(TMatrix<int_4>& mat, char flnm[]);
 void load(NTuple& ntpl,char flnm[],int hdunum);
 void load(SphericalMap<double>& sph, char flnm[]);
 void load(SphericalMap<float>& sph, char flnm[]);
 void load(LocalMap<double>& sph, char flnm[]);
 void load(ImageR4& DpcImg,char flnm[]);
 void load(ImageI4& DpcImg,char flnm[]);
 void load(SphereGorski<float>& sph, char flnm[], int hdunum=2); 
 void load(SphereGorski<double>& sph, char flnm[], int hdunum=2); 
 void save(TMatrix<double>& mat, char flnm[]);
 void save(TMatrix<float>& mat, char flnm[]);
 void save(TMatrix<int_4>& mat, char flnm[]);
 void save(NTuple& ntpl,char flnm[]);
 void save(SphericalMap<double>& sph, char flnm[]);
 void save(SphericalMap<float>& sph, char flnm[]);
 void save(SphereGorski<float>& sph, char filename[]);   
 void save(SphereGorski<double>& sph, char filename[]);   
 void save(LocalMap<double>& locm, char flnm[]);
 void save(const ImageR4& DpcImg,char flnm[]);
 void save(const ImageI4& DpcImg,char flnm[]);
 void sinus_picture_projection(SphericalMap<double>& sph, char flnm[]);
 void sinus_picture_projection(SphericalMap<float>& sph, char flnm[]);
 void Mollweide_picture_projection(SphericalMap<float>& sph, char flnm[]);
 void Mollweide_picture_projection(SphericalMap<double>& sph, char flnm[]);
 void picture(LocalMap<double>& lcm, char flnm[]);



 void readheader(char flnm[]);
 
 private :
  

 // creer, ecrire une imageformat FITS, a partir des tableaux de donnees 
 // dtab_, ftab_ prealablement remplis 
 void planck_write_img(char flnm[],int naxis,int n1,int n2,int n3,DVList& dvl);

 void planck_read_img(char flnm[],long& naxis,int& n1,int& n2,int& n3,DVList& dvl);
 void planck_read_bntbl(char flnm[], int hdunum, int& npixels, DVList& dvl);
 void planck_write_bntbl(char flnm[], int npixels, char typeOfContent[], char extname[], char comment1[], DVList& dvl);
 void write_picture(long* naxes,float* map,char* filename) const;

 void printerror(int& status) const;
 void printerror(int& status, char* texte) const;
 bool check_keyword(fitsfile*,int,char keyword[]);

 inline int key_type_PL2FITS(char typ) 
   {
     switch (typ) 
       {
       case 'I' :
	 return TINT;
       case 'D' : 
	 return TDOUBLE;
       case 'S' : 
	 return TSTRING;
       default :
	 cout << " FITSIOSERVER : type de donnee non prevu " << endl;
	 return 0;
       }
   }

 int FITS_tab_typ_;
 int_4* i_4tab_;
 r_4* r_4tab_;
 r_8* r_8tab_;
};

#endif

 

