// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: specresp.h,v 1.2 1999-11-20 21:00:52 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------
#ifndef SPECRESP_H_SEEN
#define SPECRESP_H_SEEN

#include "machdefs.h"
#include <iostream.h>

//------------------------------------
// Collaborating Class Declarations --
//------------------------------------

//              ---------------------
//              -- Class Interface --
//              ---------------------

// ***IMPORTANT*** All frequencies are expressed in GHz  (10^9 Hz)

class SpectralResponse
{

public:
  //Constructor
  SpectralResponse(double numin=0., double numax=1.);

  // destructor
  virtual ~SpectralResponse();

  //
  //  Member Functions
  //

  //  The transmission() function is virtual: 
  virtual double transmission(double nu) const =0 ; 

  inline double operator() (double nu) const { return(transmission(nu)); }

  virtual void      Print(ostream& os)  const;

  virtual double minFreq() const;
  virtual double maxFreq() const;
  virtual double meanFreq() const;
  virtual double peakFreq() const;
  virtual double peakTransmission() const;
  virtual double IntegratedSpect(double numin, double numax) const ;
  virtual double logIntegratedSpect(double numin, double numax) const ;
  virtual double IntegratedSpect() const ;
  virtual double logIntegratedSpect() const ;

protected:
  double _numin;
  double _numax;
};


// definition of the << operator
inline ostream& operator << (ostream& s,  SpectralResponse const & sr)
  {  sr.Print(s);  return(s);  }


#endif
