//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: trianglefilt.cc,v 1.2 1999-11-20 21:00:54 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream.h>

#include "trianglefilt.h"

//----------------
// Constructor --
//----------------
TriangleFilter::TriangleFilter(double numin, double numax,double nupeak, double valueatpeak)
   : SpectralResponse(numin, numax)
{
  _nuPeak = nupeak ;
  _peakTransmission = valueatpeak;
}

//--------------
// Destructor --
//--------------
TriangleFilter::~TriangleFilter()
{
}

//              ---------------------------
//              --  Function Definitions --
//              ---------------------------

double 
TriangleFilter::transmission(double nu) const
{
  if(nu < -1.e99) nu = -1.e99;
  if(nu > 1.e99) nu = 1.e99;
  
  if(nu>_numin && nu<_nuPeak) return (_peakTransmission*nu/_nuPeak);
  if(nu>=_nuPeak && nu<_numax) return (_peakTransmission*nu/(_nuPeak-_numax)+_peakTransmission-_peakTransmission*_nuPeak/(_nuPeak-_numax));
  return 0.;
}

double 
TriangleFilter::peakFreq() const 
{
return _nuPeak;
}

double 
TriangleFilter::peakTransmission() const 
{
return _peakTransmission;
}
