// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: gaussfilt.h,v 1.2 1999-11-20 21:00:49 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef GAUSSFILT_H_SEEN
#define GAUSSFILT_H_SEEN

//----------------------
// Base Class Headers --
//----------------------
#include "specresp.h"

//------------------------------------
// Collaborating Class Declarations --
//------------------------------------

//              ---------------------
//              -- Class Interface --
//              ---------------------

// Spectral response in the form  A Exp(((nu-nu0)/s)^2) 

class GaussianFilter:public SpectralResponse
{
public:
  //Constructors
  GaussianFilter (double nu0, double s, double a=1., double numin=0., double numax= 9.e49); 
  

  // destructor
  virtual ~GaussianFilter();

  //
  //  Function members
  //

  virtual double transmission(double) const;
  virtual double peakFreq() const;
  virtual double peakTransmission() const;

  virtual void   Print(ostream& os)  const;

protected:
  double _a, _s, _nu0;
};


#endif
