//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: squarefilt.cc,v 1.2 1999-11-20 21:00:53 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream.h>

#include "squarefilt.h"

//----------------
// Constructor --
//----------------
SquareFilter::SquareFilter(double numin, double numax)
  : SpectralResponse(numin, numax)
{
  _nuPeak = (numin+numax)/2.;
  _peakTransmission = transmission(_nuPeak);
}


//--------------
// Destructor --
//--------------
SquareFilter::~SquareFilter()
{
}

//              ---------------------------
//              --  Function Definitions --
//              ---------------------------


double 
SquareFilter::transmission(double nu) const
{
  if(nu < -1.e99) nu = -1.e99;
  if(nu > 1.e99) nu = 1.e99;
  
  if(nu>=_numin && nu<=_numax) return 1.;
  return 0.;
}

double 
SquareFilter::peakFreq() const 
{
return _nuPeak;
}

double 
SquareFilter::peakTransmission() const 
{
return _peakTransmission;
}
