//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: gaussfilt.cc,v 1.2 1999-11-20 21:00:48 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream.h>
#include <math.h>

#include "gaussfilt.h"

//----------------
// Constructor --
//----------------
GaussianFilter::GaussianFilter(double nu0, double s, double a, double numin, double numax)
  : SpectralResponse(numin, numax)
{
  if (s < 1.e-19) s = 1.e-19;
  _s = s;
  _nu0 = nu0;
  _a = a;
}


//--------------
// Destructor --
//--------------
GaussianFilter::~GaussianFilter()
{
}

//              ---------------------------
//              --  Function Definitions --
//              ---------------------------


double 
GaussianFilter::transmission(double nu) const
{
  if ((nu < _numin) || (nu > _numax)) return(0.);
  else { 
    double tmp = (nu-_nu0)/_s;
    return(_a * exp(tmp*tmp));
  }
}

double 
GaussianFilter::peakFreq()  const
{
return(_nu0);
}

double 
GaussianFilter::peakTransmission() const
{
return(_a);
}

void 
GaussianFilter::Print(ostream& os)  const
{ 
  os << "GaussianFilter::Print - Fmin,Fmax= " << minFreq() << "," << maxFreq() << endl;
  os << " T = A * Exp(((nu-nu0)/s)^2) : " << " nu0= " << _nu0 << " sig= " 
     << _s << "  A= " << _a << endl;  
  os << "PeakFreq= " << peakFreq() << "  Transmission= " << transmission(peakFreq()) << endl;


}
