// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: nupower.h,v 1.2 1999-11-20 21:00:49 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef NUPOWER_H_SEEN
#define NUPOWER_H_SEEN

#include "radspec.h"
#include "convtools.h"

// Power law spectra  f = a (nu-nu0)^b   
class PowerLawSpectra : public RadSpectra
{
public:   //Constructor
  
  PowerLawSpectra(double a, double b, double nu0, double numin=0., double numax=9.e49);

  virtual ~PowerLawSpectra();

  virtual double flux(double nu) const;

  // Redefintion of the Print function
  virtual void      Print(ostream& os)  const;

protected:
  double _a, _b, _nu0;
};

#endif
