//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: nupower.cc,v 1.3 1999-11-21 23:25:45 ansari Exp $
//
// Description:
//      Aim of the class: To give the energy density for a nupower
//                        The unity used here is W/m^2/Hz/sr
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream.h>
#include <math.h>

#include "nupower.h"

//----------------
// Constructor --
//----------------
PowerLawSpectra::PowerLawSpectra(double a, double b, double nu0, double dnu, double numin, double numax)
  : RadSpectra(numin, numax)
{
  _a = a;
  _b = b;
  _nu0 = nu0;
  _dnu = (dnu > 1.e-19) ? dnu : 1.;
}


PowerLawSpectra::~PowerLawSpectra()
{
}

double
PowerLawSpectra::flux(double nu) const
{
  if ((nu< _numin) || (nu > _numax)) return(0.);
  double tmp = (nu-_nu0)/_dnu;
  if (tmp <= 0.)  return(0.); 
  else return(  _a * pow(tmp, _b) );
}

void
PowerLawSpectra::Print(ostream& os) const
{
  os << "PowerLawSpectra::Print f = a ((nu-nu0)/dnu)^b " << _a << "((nu-" << _nu0 
     << ") / " << _dnu << ") ^ " << _b << endl;
  os << " - Fmin,Fmax= " << minFreq() << "," << maxFreq() << endl;
  os << "MeanFreq= " << meanFreq() << "  Emission= " << flux(meanFreq()) << endl;
  os << "PeakFreq= " << peakFreq() << "  Emission= " << flux(peakFreq()) << endl;

}
