// toiboloproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "toiboloproducer.h"
#include "archexc.h"
#include "requesthandler.h"
#include "polfitclip.h"

#define boloMuV "boloMuV"


TOIBoloProducer::TOIBoloProducer() {
  possibleTOIs.insert(TOI(boloMuV, TOI::all, "linfilt sqfilt", "microVolts"));  
}

// No option == linfilt

string TOIBoloProducer::getName() {
  return("TOIBoloProducer 1.1");
}

int TOIBoloProducer::filtHalfRange = 20;


void TOIBoloProducer::dataFeed(TOIProducer* source, TOI const& toi, long sampleNum, double value) {
  if (source->canGetValue(sampleNum-1, toi)) {
    value = (value + source->getValue(sampleNum-1, toi))/2.;
    
    //TOI toi2 = toi;
    //toi2.name = boloMuV;

    TOI toi2(boloMuV, toi.index, "sqfilt", toi.unit);
    computedValue(toi2, sampleNum, value);
  }
  
  // $CHECK$ possible optimization : keep fit for several successive values
  
  if (source->canGetValue(sampleNum-2*filtHalfRange, toi)) {
    PolFitClip fit(2*filtHalfRange,1);
    int s = sampleNum % 2 ? 1 : -1;
    for (int i=0; i<2*filtHalfRange-1; i++) {
      fit.addData(sampleNum - i, 
         s*(source->getValue(sampleNum - i, toi) -  source->getValue(sampleNum - i -1, toi))/2);
      s = -s;
    }
    fit.doFit();
    double y = source->getValue(sampleNum - filtHalfRange, toi);
    s = sampleNum % 2 ? 1 : -1;
    y =y - s*fit.value(sampleNum - filtHalfRange);
    TOI toi2(boloMuV, toi.index, "linfilt", toi.unit);
    if (isProducing(toi2))
      computedValue(toi2, sampleNum - filtHalfRange, y);
    TOI toi3(boloMuV, toi.index, "", toi.unit);
    if (isProducing(toi3))
      computedValue(toi3, sampleNum - filtHalfRange, y);
  }
}

set<TOI> TOIBoloProducer::reqTOIFor(TOI const& toi) {
  set<TOI> t; 
  if (toi.name == boloMuV) {
    TOI toi2("boloRawMuV", toi.index);
    //toi2.name = "boloRawMuV";
    t.insert(toi2);
  } else {
    throw ArchExc("Cannot produce "+toi.name);
  }
  return t;
}


void TOIBoloProducer::propagateLowBound(TOI const& toi, long sampleNum) {
  CHKPROD
  map<TOI, TOIProducer*> & need = neededTOIs[toi];
  int hlen = 1;
  for (map<TOI, TOIProducer*>::iterator i = need.begin(); i != need.end(); i++) {
    (*i).second->wontNeedEarlier((*i).first, this, sampleNum-hlen);
  }
}



