// polfitclip.h
// Eric Aubourg         CEA/DAPNIA/SPP   novembre 1999

#ifndef POLFITCLIP_H
#define POLFITCLIP_H

#include <stdlib.h>

class PolFitClip {
public:
  PolFitClip(long ndatamax, long degpol);
  ~PolFitClip();
  
  void setData(double const* x, double const* y, long n);
  void addData(double xx, double yy);
  void clear();
  void setClip(double frc, double nsig, int npass);

  int doFit(double* coef=NULL);
  int doFit1();
  
  double value(double x);
  
  long getNData();
  double getXMin();
  double getXMax();
  
  double getChi2();
  double getCov(int i, int j);
  double getSigma();

protected:
  double*  x;
  double*  ySort;
  double*  y;
  double*  sig;
  double*  a;
  int*     ia;
  double** cov;
  long     ndata;
  long     ndatamax;
  double   chi2;
  
  long     nparm;
  
  double   frc;
  double   nsig;
  int      npass;
  
  double sigma;
};

class PolFitClip2 {
public:
  PolFitClip2(long ndatamax, long degpol);
  ~PolFitClip2();
  
  void setData(double const* x, double const* y, double const* z, long n);
  void addData(double xx, double yy, double zz);
  void clear();
  void setClip(double frcY, double frcZ, double nsig, int npass);

  int doFit(double* coefY=NULL, double* coefZ=NULL);
  int doFit1();
  
  double valueY(double x);
  double valueZ(double x);
  
  long  getNData();
  long  getNDataUsed();
  double getXMin();
  double getXMax();
  
  double getChi2Y();
  double getChi2Z();
  double getCovY(int i, int j);
  double getCovZ(int i, int j);
  double getSigmaY();
  double getSigmaZ();

protected:
  double*  x;
  double*  ySort;
  double*  y;
  double*  zSort;
  double*  z;
  double*  sig;
  double*  aY;
  double*  aZ;
  int*     ia;
  double** covY;
  double** covZ;
  long     ndata;
  long     ndataused;
  long     ndatamax;
  double   chi2Y;
  double   chi2Z;
  
  long     nparm;
  
  double   frcY;
  double   frcZ;
  double   nsig;
  int      npass;
  
  double   sigmaY;
  double   sigmaZ;
};


#endif
