/* Fonctions interface XWindow pour affichage d'images */

#ifndef PIPIXMAP_H_SEEN
#define PIPIXMAP_H_SEEN

#include "pisysdep.h"

#include PIBWDG_H
#include PICMAP_H

#include <list>

class PIPixmapGen : public PIBaseWdg
{
public:
  enum {ClassId = 5100};

  enum { PIDEL_Line = 1, PIDEL_Text = 2,
         PIDEL_Rect = 3, PIDEL_FRect = 4, 
         PIDEL_Circ = 5, PIDEL_FCirc = 6 } ; 

                PIPixmapGen(PIContainerGen *par, char *nom,
                         int sx=10, int sy=10, int px=0, int py=0);
  virtual       ~PIPixmapGen();

  virtual long  kind() {return ClassId; }

  virtual void  SetPixmap(unsigned char *pix, int sx, int sy, 
                          bool refr=true, int ox=0, int oy=0);
  void          SetColMap(CMapId cmapid, bool refr=true);
  inline CMapId GetColMapId() { return ((CMapId)cmap->Type()); }; 
  inline int    NbCol() { return(cmap->NCol()); };

  virtual void  But1Press(int x, int y);
  inline  int   XPPos() { return mPpos[0]; }
  inline  int   YPPos() { return mPpos[1]; }

  inline int    ElAddLine(int x1, int y1, int x2, int y2)
    { return( ElAdd(PIDEL_Line, x1, y1, x2, y2, NULL) ); }  
  inline int    ElAddText(int x, int y, char* s)
    { return( ElAdd(PIDEL_Text, x, y, 0, 0, s) ); }  
  inline int    ElAddRect(int x, int y, int dx, int dy)
    { return( ElAdd(PIDEL_Rect, x, y, dx, dy, NULL) ); }  
  inline int    ElAddFRect(int x, int y, int dx, int dy)
    { return( ElAdd(PIDEL_FRect, x, y, dx, dy, NULL) ); }  
  inline int    ElAddCirc(int x, int y, int r)
    { return( ElAdd(PIDEL_Circ, x, y, r, r, NULL) ); }  
  inline int    ElAddFCirc(int x, int y, int r)
    { return( ElAdd(PIDEL_FCirc, x, y, r, r, NULL) ); }  

  void          ElDel(int id);
  void          ElDelAll();

protected:
  int           ElAdd(int typ, int x, int y, int dx, int dy, char* s);
  virtual void  DrawElements();

  unsigned char *pixmap;
  int nx, ny;
  int ofx, ofy;
  PIColorMap* cmap;

#ifdef __DECCXX
public:
#endif
  struct DrwEl{
    int eid, etyp;
    int ex,ey;
    int edx,edy;
    string es;
  };
#ifdef __DECCXX
protected:
#endif
  typedef list<DrwEl> DrwElList;

  DrwElList mElist;
  int mEn;
  int mPpos[2];
};  
  



#endif   /* PIPIXMAP_H_SEEN */


