#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include "pixtbaseP.h"
#include "pixtbase.h"

#include "pibwdgx.h"
#include "pidrawer.h"
#include "psfile.h"


/*  Variables globales pour modifier les GC  */
#define NMAXFONTSZ  5
static XFontStruct * fntst[NMAXFONTSZ][3];
static int fntsz[NMAXFONTSZ] = {8,10,12,14,16};
static  PIFontAtt fntatt[3] = { PI_RomanFont, PI_BoldFont, PI_ItalicFont }; 
#define NMAXCOL  10
static unsigned long colpix[NMAXCOL];
#define NMAXCURS 5 
static Cursor curs[NMAXCURS];

/*  GC pour DrawPixmap   */
static GC dpxgc;

// #define DEBUG_PIBWDGX     Flag pour impression de debug etc ...


/* --Methode-- */
PIBaseWdgX::PIBaseWdgX(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: PIBaseWdgGen(par, nom, sx, sy, px, py)

{
Arg  wargs[3];

Init();

CreateXtWdg(nom, piXtBaseWidgetClass, NULL, sx, sy, px, py);

XtSetArg(wargs[0],PIXNobject,this); 
XtSetArg(wargs[1],XtNbackground, colpix[PI_White]);  
XtSetArg(wargs[2],XtNborderWidth, (Dimension)0);  
XtSetValues(XtWdg(), wargs, 3);

XtUninstallTranslations(XtWdg());

mDefGC = XCreateGC (PIXDisplay(), XtWindow(PIXtTopWdg()), 0, NULL);
mGOm = PI_GOCopy;

mFCol = mBCol = PI_Grey;
SelForeground(PI_Black);
SelBackground(PI_White);
mLAtt = PI_ThinLine;
SelLine();
mFAtt = PI_BoldFont;  mFSize = 0;
SelFont();
mPtrS = PI_CrossPointer;
SelPointerShape();
SelMarker(1, PI_DotMarker);

Manage();
}


/* --Methode-- */
PIBaseWdgX::~PIBaseWdgX()
{
#ifdef DEBUG_PIBWDGX 
printf("PIBaseWdgX::~PIBaseWdgX()_Debug: Object= %lx (%lx) Wdg= %lx \n",
(long)this, (long)(((PIXtBaseWidget)XtWdg())->pixtbase.objet), (long)XtWdg() );  
#endif
Arg  wargs[2];
XtSetArg(wargs[0],PIXNobject,NULL); 
XtSetValues(XtWdg(), wargs, 1);
}

/* --Methode-- */
void PIBaseWdgX::FinishCreate()
{
// appele par la fenetre mere, apres XtRealize()
// J'active le backing store pour la fenetre X
XSetWindowAttributes xswa;
Window mwi;
mwi = XtWindow(XtWdg());
xswa.backing_store = WhenMapped;
xswa.backing_planes = ~0;
XChangeWindowAttributes(PIXDisplay(), XtWindow(XtWdg()), CWBackingPlanes|CWBackingStore, &xswa);
} 

/* --Methode-- */
void PIBaseWdgX::ActivatePtrCross()
{
XtTranslations trans;
trans = XtParseTranslationTable
        ("<Enter>: enter_pixtbase() \n <Leave>: leave_pixtbase()");
XtAugmentTranslations(XtWdg(), trans);
//XtFree((char *)trans);

return;
}


/* --Methode-- */
void PIBaseWdgX::ActivateButton(int bid)
{
XtTranslations trans;
char strans[256];
if ((bid<1) || (bid > 3))  return;
sprintf(strans,"<Btn%dDown>: bud%d_pixtbase() \n <Btn%dUp>: buu%d_pixtbase()",
        bid, bid, bid, bid);
trans = XtParseTranslationTable(strans);

XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
#ifdef DEBUG_PIBWDGX
printf("PIBaseWdgX::ActivateButton \n%s \n", strans);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::ActivateMove(int bid)
{
XtTranslations trans;
char strans[256];
if ((bid<1) || (bid > 3))  return;
sprintf(strans,"<Btn%dMotion>: mov%d_pixtbase()", bid, bid);
//sprintf(strans,"Button%d <PtrMoved>: mov%d_pixtbase()", bid, bid);
trans = XtParseTranslationTable(strans);

XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
#ifdef DEBUG_PIBWDGX
printf("PIBaseWdgX::ActivateMove \n%s \n", strans);
#endif
return;
}


/* --Methode-- */
void PIBaseWdgX::ActivateKeyboard()
{
XtTranslations trans;
trans = XtParseTranslationTable("<Key>: keyb_pixtbase()");
XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
return;
}


/* --Methode-- */
void PIBaseWdgX::EraseWindow(int x0, int y0, int dx, int dy)
{
if(mPSOut) return;
XClearArea (XtDisplay(XtWdg()),XtWindow(XtWdg()), x0, y0, dx, dy, False );
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawString(int x, int y, char* s, int /*pos*/)
{
if(mPSOut){
mPSOut->DrawString((float)x,(float)y,s,mFCol,mFAtt,mFSize); /* $CHECK$ PIFontSize ?? */
}
else
XDrawString (XtDisplay (XtWdg()),XtWindow(XtWdg()), 
                  DefGC(), x, y, s, strlen(s));
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawOpaqueString(int x, int y, char* s, int /*pos*/)
{
if(mPSOut){
mPSOut->DrawString((float)x,(float)y,s,mFCol,mFAtt,mFSize); /* $CHECK$ PIFontSize ?? */
}
else
XDrawImageString (XtDisplay (XtWdg()),XtWindow(XtWdg()), 
                  DefGC(), x, y, s, strlen(s));
return;
}

 
/* --Methode-- */
void PIBaseWdgX::DrawLine(int x1, int y1, int x2, int y2)
{
if(mPSOut){
mPSOut->DrawLine((float)x1,(float)y1,(float)x2,(float)y2,
		 mFCol,mLAtt);
}
else
XDrawLine(XtDisplay (XtWdg()), XtWindow(XtWdg()), DefGC(), x1, y1, x2, y2);
return;
}


/* --Methode-- */
void PIBaseWdgX::DrawBox(int x0, int y0, int dx, int dy)
{
if(mPSOut)
mPSOut->DrawBox((float)x0,(float)y0,(float)dx,(float)dy,mFCol,mLAtt);
else{
if (dx < 0)  { x0 += dx;  dx = -dx; }
if (dy < 0)  { y0 += dy;  dy = -dy; }
XDrawRectangle(XtDisplay (XtWdg()), XtWindow(XtWdg()), 
               DefGC(), x0, y0, dx, dy);
}
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawFBox(int x0, int y0, int dx, int dy)
{
if(mPSOut)
mPSOut->DrawFBox((float)x0,(float)y0,(float)dx,(float)dy, mFCol, mFCol, mLAtt);
else{
if (dx < 0)  { x0 += dx;  dx = -dx; }
if (dy < 0)  { y0 += dy;  dy = -dy; }
XFillRectangle(XtDisplay (XtWdg()), XtWindow(XtWdg()), 
               DefGC(), x0, y0, dx, dy);
}
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawCircle(int x0, int y0, int r)
{
if(mPSOut)
mPSOut->DrawCircle((float)x0,(float)y0,(float)r,mFCol,mLAtt);
else
XDrawArc(XtDisplay (XtWdg()), XtWindow(XtWdg()), DefGC(),
         x0-r, y0-r, 2*r, 2*r, 0, 360*64);
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawFCircle(int x0, int y0, int r)
{
if(mPSOut)
mPSOut->DrawFCircle((float)x0,(float)y0,(float)r,mFCol,mFCol,mLAtt);
else
XFillArc(XtDisplay (XtWdg()), XtWindow(XtWdg()), DefGC(),
         x0-r, y0-r, 2*r, 2*r, 0, 360*64);
return;
}

// Pour les fonctions de trace avec un plusieurs coordonnees
#define NMXXPOINTS  30 

/* --Methode-- */
void PIBaseWdgX::DrawPolygon(int *x, int *y, int n)
{
XPoint multipoint[NMXXPOINTS];
XPoint *pxp;
int i;
float *xtmp;
float *ytmp;

if(mPSOut)
{
xtmp = new float[n];
ytmp = new float[n];
for(i=0;i<n;i++){
  xtmp[i] = (float)x[i];
  ytmp[i] = (float)y[i];
}
mPSOut->DrawPolygon(xtmp,ytmp,n,mFCol,mLAtt);
delete[] xtmp;
delete[] ytmp;
}
else {
if (n <= 0)  return;
if (n > NMXXPOINTS)  pxp = new XPoint[n];
else pxp = multipoint;
for(i=0; i<n; i++)  { pxp[i].x = x[i];  pxp[i].y = y[i]; } 
XDrawLines(XtDisplay(XtWdg()), XtWindow(XtWdg()), DefGC(), pxp, n, CoordModePrevious);
if (n > NMXXPOINTS)  delete[] pxp;
}
return;
}


/* --Methode-- */
void PIBaseWdgX::DrawFPolygon(int *x, int *y, int n)
{
XPoint multipoint[NMXXPOINTS];
XPoint *pxp;
int i;
float *xtmp;
float *ytmp;

if(mPSOut)
{
xtmp = new float[n];
ytmp = new float[n];
for(i=0;i<n;i++){
  xtmp[i] = (float)x[i];
  ytmp[i] = (float)y[i];
}
mPSOut->DrawFPolygon(xtmp,ytmp,n,mFCol,mFCol,mLAtt);
delete[] xtmp;
delete[] ytmp;
}
else
{
if (n <= 0)  return;
if (n > NMXXPOINTS)  pxp = new XPoint[n];
else pxp = multipoint;
for(i=0; i<n; i++)  { pxp[i].x = x[i];  pxp[i].y = y[i]; } 
XFillPolygon(XtDisplay (XtWdg()), XtWindow(XtWdg()), DefGC(), pxp, n, 
                        Complex, CoordModePrevious);
if (n > NMXXPOINTS)  delete[] pxp;
}
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawMarker(int x0, int y0)
{
int hmsz = mMrkSz/2;
int dmsz = mMrkSz-hmsz;
int x[4],y[4];
PILineAtt clatt;
if(mPSOut)
mPSOut->DrawMarker((float)x0,(float)y0,mMrk,mFCol,mMrkSz);
else
{
if (mMrk == PI_DotMarker)
  XDrawPoint(XtDisplay(XtWdg()), XtWindow(XtWdg()), DefGC(), x0, y0);

else
  {
  clatt = mLAtt;
  SelLine(PI_ThinLine);
  switch (mMrk)
    {
    case  PI_PlusMarker :
      DrawLine(x0-hmsz, y0, x0+dmsz, y0);
      DrawLine(x0, y0-hmsz, x0, y0+dmsz);
      break;
    case  PI_CrossMarker :
      DrawLine(x0-hmsz, y0-hmsz, x0+dmsz, y0+dmsz);
      DrawLine(x0-hmsz, y0+dmsz, x0+dmsz, y0-hmsz);
      break;  
    case PI_CircleMarker :
      DrawCircle(x0, y0, hmsz);
      break;
    case PI_FCircleMarker :
      DrawFCircle(x0, y0, hmsz);
      break;
    case PI_BoxMarker :
      DrawBox(x0-hmsz, y0-hmsz, mMrkSz, mMrkSz);
      break;
    case PI_FBoxMarker :
      DrawFBox(x0-hmsz, y0-hmsz, mMrkSz, mMrkSz);
      break;
    case  PI_TriangleMarker :
      x[1] = mMrkSz; y[1] = 0; x[2] = -hmsz; y[2] = -mMrkSz; 
      x[3] = -dmsz; y[3] = +mMrkSz; x[0] = x0-hmsz; y[0] = y0+hmsz;  
      DrawPolygon(x, y, 4);
      break;
    case  PI_FTriangleMarker :
      x[1] = mMrkSz; y[1] = 0; x[2] = -hmsz; y[2] = -mMrkSz; 
      x[3] = -dmsz; y[3] = +mMrkSz; x[0] = x0-hmsz; y[0] = y0+hmsz;  
      DrawFPolygon(x, y, 4);
      break;
    default :
      XDrawPoint(XtDisplay(XtWdg()), XtWindow(XtWdg()), DefGC(), x0, y0);
      break;
    }
  SelLine(clatt);
  }
}
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawMarkers(int *x, int *y, int n)
{
int i;
float *xtmp;
float *ytmp;

if(mPSOut)
{
xtmp = new float[n];
ytmp = new float[n];
for(i=0;i<n;i++){
  xtmp[i] = (float)x[i];
  ytmp[i] = (float)y[i];
}
mPSOut->DrawMarkers(xtmp,ytmp,n,mMrk,mFCol, mMrkSz);
delete[] xtmp;
delete[] ytmp;
}
else
{
if (n <= 0)  return;
if (mMrk == PI_DotMarker)
  {
  XPoint multipoint[NMXXPOINTS];
  XPoint *pxp;
  if (n > NMXXPOINTS)  pxp = new XPoint[n];
  else pxp = multipoint;
  for(i=0; i<n; i++)  { pxp[i].x = x[i];  pxp[i].y = y[i]; } 
  XDrawPoints(XtDisplay(XtWdg()), XtWindow(XtWdg()), DefGC(), pxp, n, CoordModeOrigin);
  if (n > NMXXPOINTS)  delete[] pxp;  
  }
else for(i=0; i<n; i++) DrawMarker(x[i], y[i]);
}
}


/* --Methode-- */
void PIBaseWdgX::DrawPixmap(int x, int y, unsigned char *pix, 
                            int sx, int sy, PIColorMap* cmap)
{
Window xw;
Display * mdsp;
int scr;
int depth;
int pad;
int i,j;
XImage * ximg;

if ( (sx < 1) || (sy < 1) )  return;
if ((pix == NULL) || (cmap == NULL)) return; 

if(mPSOut) {
  mPSOut->Image((float)x, (float)y, (float)sx, (float)sy, sx, sy, pix, cmap);
  return;
  }
  
xw = XtWindow(XtWdg());
mdsp = PIXDisplay();
scr = PIXScreen();

depth = DefaultDepth(mdsp,scr);
pad = (depth > 8) ? 32 : 8;
ximg = XCreateImage (mdsp,DefaultVisual(mdsp,scr),
                     depth,ZPixmap,0,NULL, sx, sy, pad,0);
if (ximg == NULL)  return;
ximg->data = new char [sy*ximg->bytes_per_line];
if (ximg->data == NULL)  
  { XFree(ximg); return; }

for(j=0; j<sy; j++)
  for(i=0; i<sx; i++)
    { XPutPixel(ximg, i, j, cmap->Color(*pix) );  pix++; }

XPutImage(mdsp, xw, dpxgc, ximg, 0, 0, x, y, sx, sy);

delete[] ximg->data;
XFree(ximg); 
return;
}


/* --Methode-- */
int PIBaseWdgX::CalcStringWidth(char const* s)
{
return(XTextWidth(mFSt, s, strlen(s)));
}

/* --Methode-- */
void PIBaseWdgX::SelForeground(PIColors col)
{
if (col == mFCol)  return;
if ( (col < 0) || (col >= NMAXCOL))  return;
XSetForeground(XtDisplay(XtWdg()), DefGC(), colpix[col]); 
mFCol = col;
return;
}

/* --Methode-- */
void PIBaseWdgX::SelBackground(PIColors col)
{
if (col == mBCol)  return;
if ( (col < 0) || (col >= NMAXCOL))  return;
XSetBackground(XtDisplay(XtWdg()), DefGC(), colpix[col]); 
mBCol = col;
return;
}

/* --Methode-- */
void PIBaseWdgX::SelGOMode(PIGOMode mod)
{
if (mod == mGOm)  return;
switch (mod)
  {
  case PI_GOCopy :
    XSetFunction(XtDisplay(XtWdg()), DefGC(), GXcopy);
    mGOm = mod;
    break;
  case PI_GOXOR :
    XSetFunction(XtDisplay(XtWdg()), DefGC(), GXxor);
    mGOm = mod;
    break;
  }
return;
}


/* --Methode-- */
void PIBaseWdgX::SelFontSzPt(int npt, PIFontAtt att)
{
int dsz,i,isel, j;

if ((npt == mFSize) && (att == mFAtt))  return;
isel = 0;
dsz = 9999;
for(i=0; i<NMAXFONTSZ; i++)
  {
  j = npt - fntsz[i];   if (j < 0)  j = -j;
  if (j < dsz)  {  isel = i; dsz = j; }
  }

j = 0;
if (att & PI_RomanFont) j = 0;
if (att & PI_BoldFont) j = 1;
if (att & PI_ItalicFont) j = 2;

SelectFont(isel, j);

}

/* --Methode-- */
void PIBaseWdgX::SelFont(PIFontSize sz, PIFontAtt att)
{
int i,j;
switch (sz)
  {
  case PI_SmallSizeFont:
    i = 0;
    break;
  case PI_NormalSizeFont:
    i = 2;
    break;
  case PI_BigSizeFont:
    i = 4;
    break;
  default:
    i=2;
    break;
  }

j = 0;
if (att & PI_RomanFont) j = 0;
if (att & PI_BoldFont) j = 1;
if (att & PI_ItalicFont) j = 2;

SelectFont(i, j);
}



/* --Methode-- */
void PIBaseWdgX::SelLine(PILineAtt att)
{
unsigned int lt;

if (att == mLAtt)  return;

switch (att)
  {
  case PI_NormalLine :
    lt = 2;
    break;
  case PI_ThickLine :
    lt = 4;
    break;
  case  PI_ThinLine :
    lt = 0;
    break;
  default:
    lt = 0;
    break;
  }
    
XSetLineAttributes(XtDisplay(XtWdg()), DefGC(), lt, LineSolid, CapButt, JoinMiter);
mLAtt = att;
return;
}


/* --Methode-- */
void PIBaseWdgX::SelPointerShape(PIPointer ptr)  
{
if (ptr == mPtrS)  return;
if ( (ptr < 0) || (ptr >= NMAXCURS))  return;
if ( XtIsRealized(XtWdg()) )
  XDefineCursor(XtDisplay (XtWdg()), XtWindow(XtWdg()), curs[ptr]);
mPtrS = ptr;
return;
}

/* --Methode-- */
void PIBaseWdgX::SelMarker(int msz, PIMarker mrk)
{
if (msz > 1)  { mMrk = mrk;  mMrkSz = msz; }
else  { mMrk = PI_DotMarker;  mMrkSz = 1; }
return;
}


/* --Methode-- */
void PIBaseWdgX::SetClipRectangle(int x0, int y0, int dx, int dy)
{
XRectangle xr;
xr.x = x0;  xr.y = y0;
xr.width = dx;  xr.height = dy;
XSetClipRectangles(XtDisplay(XtWdg()), DefGC(), 0, 0, &xr, 1, Unsorted);
XSetClipRectangles(XtDisplay(XtWdg()), dpxgc, 0, 0, &xr, 1, Unsorted);
return;
}

/* --Methode-- */
void PIBaseWdgX::ClearClipRectangle()
{ 
XSetClipMask(XtDisplay(XtWdg()), DefGC(), None);
XSetClipMask(XtDisplay(XtWdg()), dpxgc, None);
return;
}

/* --Methode-- */
PIColors  PIBaseWdgX::GetForeground() 
{
return (mFCol);
}

/* --Methode-- */
PIColors  PIBaseWdgX::GetBackground() 
{
return (mBCol);
}


/* --Methode-- */
PIGOMode   PIBaseWdgX::GetGOMode()
{
return (mGOm);
}

/* --Methode-- */
PIFontAtt  PIBaseWdgX::GetFontAtt()
{
return (mFAtt);
}

/* --Methode-- */
int        PIBaseWdgX::GetFontSize()
{
return (mFSize);
}

/* --Methode-- */
PILineAtt  PIBaseWdgX::GetLineAtt()
{
return (mLAtt);
}

/* --Methode-- */
PIPointer  PIBaseWdgX::GetPointerShape()
{
return (mPtrS);
}

/* --Methode-- */
PIMarker   PIBaseWdgX::GetMarker()
{
return (mMrk);
}

/* --Methode-- */
int        PIBaseWdgX::GetMarkerSize()
{
return (mMrkSz);
}

/* --Methode-- */
int        PIBaseWdgX::GetFontHeight(int& asc, int& desc)   
{
char a[2];
XCharStruct  ovr;
int hd, fa, fd;
XTextExtents(mFSt, a, 0, &hd, &fa, &fd, &ovr);
asc = fa; desc = fd; 
return(fa+fd);
}


/* --Methode-- */
void PIBaseWdgX::SaveGraphicAtt()
{  
// Pour optimier l'implementation de PIBaseWdgGen
sFCol = mFCol;    sBCol = mBCol;
sGOm = mGOm;
sFAtt = mFAtt;   sFSize = mFSize;
sMrk = mMrk;   sMrkSz = mMrkSz;
return;
}



static bool fgbwdg = false ;

// Le bazar pour recuperer des resources de .Xdefault et autres 
typedef struct 
  {
  String fntFam;
  } myAppData;
static myAppData  apd;

static XtResource resources[] = {
  { "fontFamilyName", "FontFamilyName", XtRString, sizeof(String),
    /*XtOffset(apdp, fntFam)*/ 0, XtRString, "*-helvetica" }
};
 
static char * fnbi_b[4] = { "medium-r-normal", "bold-r-normal", 
                          "medium-o-normal", "medium-i-normal" };

static XFontStruct * defnt = NULL;
static char * fnbi[3];


/* --Methode-- */
void PIBaseWdgX::Init()
{
char buff[256];
int i,j,k, count;
char **list;

if (fgbwdg)  return;
fgbwdg = true;

Display *mdsp;
int scr;
XColor exact,mycol;
Colormap  cmap;

mdsp = PIXDisplay();
scr = XDefaultScreen(mdsp);

XtGetApplicationResources(PIXtTopWdg(), &apd, resources, 
                          XtNumber(resources), NULL, 0);
sprintf(buff,"-%s-*-*-*-*-*-*-*-*-*-*-*-*", apd.fntFam);
list = XListFonts(mdsp, buff, 15, &count);
XFreeFontNames(list);
if (count < 5)
  { 
  printf("PIBaseWdgX::Init %d fonts found for %s , switching to helvetica\n",
         count, apd.fntFam);
  apd.fntFam = "*-helvetica";
  }
sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[0]);
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
if (count < 2) fnbi[0] = "*-*-*";
else  fnbi[0] = fnbi_b[0];
sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[1]);
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
if (count < 2) fnbi[1] = "*-*-*";
else  fnbi[1] = fnbi_b[1];
sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[2]);
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
fnbi[2] = fnbi_b[2];
if (count < 2) 
  {
  sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[3]);
  list = XListFonts(mdsp, buff, 10, &count);
  XFreeFontNames(list);
  fnbi[2] = fnbi_b[3];
  }
if (count < 2) fnbi[2] = "*-*-*";

sprintf(buff,"-*-fixed-*-*-*-*-14-*-*-*-*-*-*-*");
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
if (count < 1) 
  {  
  sprintf(buff,"fixed");
  list = XListFonts(mdsp, buff, 10, &count);
  XFreeFontNames(list);
  }
if (count < 1) 
  {  
  strcpy(buff,"");
  list = XListFonts(mdsp, buff, 10, &count);
  XFreeFontNames(list);
  printf("PIBaseWdgX::Init/ Erreur, no font found ... \n");
  defnt = NULL;
  }
else defnt = XLoadQueryFont(mdsp, buff);

for (i=0; i<NMAXFONTSZ; i++)
  for (j=0; j<3; j++)  fntst[i][j] = NULL;

 
/*  Les couleurs  */
cmap = XDefaultColormap (mdsp, scr);

for(i=0; i<NMAXCOL; i++)  colpix[i] = XWhitePixel(mdsp, scr);
colpix[PI_Black] = XBlackPixel(mdsp, scr);
colpix[PI_White] = XWhitePixel(mdsp, scr);
if ( XAllocNamedColor (mdsp, cmap, "LightGray", &mycol, &exact) )
  colpix[PI_Grey] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "red", &mycol, &exact) )
  colpix[PI_Red] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "blue", &mycol, &exact) )
  colpix[PI_Blue] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "green", &mycol, &exact) )
  colpix[PI_Green] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "yellow", &mycol, &exact) )
  colpix[PI_Yellow] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "magenta", &mycol, &exact) )
  colpix[PI_Magenta] = mycol.pixel;

curs[0] = XCreateFontCursor(mdsp, XC_X_cursor);
for(i=1; i<NMAXCURS; i++)  curs[i] = curs[0];

curs[PI_ArrowPointer] =  XCreateFontCursor(mdsp, XC_arrow);
curs[PI_CrossPointer] =  XCreateFontCursor(mdsp, XC_crosshair);
curs[PI_HandPointer] =  XCreateFontCursor(mdsp, XC_hand2);
curs[PI_TDLRArrowPointer] =  XCreateFontCursor(mdsp, XC_fleur);

/*  le GC pour DrawPixmap  */
XGCValues  xgv;
xgv.function = GXcopy;
xgv.plane_mask = ~0;
dpxgc = XCreateGC(mdsp, DefaultRootWindow(mdsp), GCFunction | GCPlaneMask, &xgv);

return;
}


/* --Methode-- */
void PIBaseWdgX::SelectFont(int isz, int jat)
{

if (!fntst[isz][jat])  // Il faut charger la fonte
  {
  char buff[256];
  int count,k;
  Display * mdsp = PIXDisplay();
  char **list;

  for (k=0; k<5; k++)    // Recherche de la fonte pour tailles croissantes
    {
    sprintf(buff,"-%s-%s-*-%d-*-*-*-*-*-*-*", apd.fntFam, fnbi[jat], fntsz[isz]+k);
    list = XListFonts(mdsp, buff, 10, &count);
    XFreeFontNames(list);
    if (count > 0)  break;
    }
  if (count > 0)
    fntst[isz][jat] = XLoadQueryFont(mdsp, buff);
  else
    { printf("PIBaseWdgX::SelectFont/ Pb font %s - Using default \n", buff);    
    fntst[isz][jat] = defnt; }
  }

mFAtt = fntatt[jat];
mFSize = fntsz[isz];
mFSt = fntst[isz][jat];
XSetFont(XtDisplay(XtWdg()), DefGC(), fntst[isz][jat]->fid);
return;
}


