#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include <X11/keysym.h>

#include "pixtbaseP.h"
#include "pixtbase.h"

// #define DEBUG_PIXTB

/*  Construction du widget Xt PIXtBase   */

static void     init_class_pixtbase(void);

static void     init_pixtbase    (Widget, Widget, ArgList, Cardinal*);
static void     destroy_pixtbase (Widget);
static void     resize_pixtbase  (Widget);
static void     expose_pixtbase  (Widget, XEvent*, Region);


static void     leave_pixtbase   (Widget, XEvent*, String* ,Cardinal*);
static void     enter_pixtbase   (Widget, XEvent*, String* ,Cardinal*);
static void     buu1_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     bud1_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     buu2_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     bud2_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     buu3_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     bud3_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     mov1_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     mov2_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     mov3_pixtbase    (Widget, XEvent*, String* ,Cardinal*);
static void     keyb_pixtbase    (Widget, XEvent*, String* ,Cardinal*);


static XtResource resources[] ={
  {PIXNobject ,"Object", XtRPointer, sizeof(XtRPointer),
   XtOffset(PIXtBaseWidget,  pixtbase.objet), XtRImmediate, (XtPointer)0},
};

/*
static char translations[] =  "\
                      <BtnDown>: bud1_pixtbase(None)\n\
             Button1 <PtrMoved>: mov1_pixtbase(None)\n\
                        <BtnUp>: buu1_pixtbase(None)\n\
                          <Key>: keyb_pixtbase(None)";
*/

static XtActionsRec actions[] = 
{
  { "leave_pixtbase" , (XtActionProc)leave_pixtbase} ,
  { "enter_pixtbase" , (XtActionProc)enter_pixtbase} ,
  { "buu1_pixtbase" , (XtActionProc)buu1_pixtbase} ,
  { "bud1_pixtbase" , (XtActionProc)bud1_pixtbase} ,
  { "buu2_pixtbase" , (XtActionProc)buu2_pixtbase} ,
  { "bud2_pixtbase" , (XtActionProc)bud2_pixtbase} ,
  { "buu3_pixtbase" , (XtActionProc)buu3_pixtbase} ,
  { "bud3_pixtbase" , (XtActionProc)bud3_pixtbase} ,
  { "mov1_pixtbase" , (XtActionProc)mov1_pixtbase} ,
  { "mov2_pixtbase" , (XtActionProc)mov2_pixtbase} ,
  { "mov3_pixtbase" , (XtActionProc)mov3_pixtbase} ,
  { "keyb_pixtbase" , (XtActionProc)keyb_pixtbase} ,
};

PIXtBaseClassRec  piXtBaseClassRec = {
/* Core Class Part */
{

(WidgetClass) &coreClassRec,    /* pointer to superclass ClassRec   */
"PIXtBase",         		/* widget resource class name       */
sizeof(PIXtBaseRec),	        /* size in bytes of widget record   */
init_class_pixtbase,            /* class_initialize                 */
NULL, 			        /* dynamic initialization           */
FALSE,       		        /* has class been initialized?      */
init_pixtbase,                  /* initialize                       */
NULL,			        /* notify that initialize called    */
XtInheritRealize,               /* XCreateWindow for widget         */
actions,     		        /* widget semantics name to proc map*/
XtNumber(actions),              /* number of entries in actions     */
resources,                      /* resources             */
XtNumber(resources),            /* resources             */
NULLQUARK,		        /* resource class quarkified        */
TRUE,			        /* compress MotionNotify for widget */
TRUE,			        /* compress Expose events for widget*/
TRUE,			        /* compress enter and leave events  */
TRUE,			        /* select for VisibilityNotify      */
destroy_pixtbase,	        /* free data for subclass pointers  */
resize_pixtbase,                /* geom manager changed widget size */
expose_pixtbase,       	        /* rediplay window                  */
NULL,		                /* set subclass resource values     */
NULL,			        /* notify that set_values called    */
XtInheritSetValuesAlmost,       /* set_values got "Almost" geo reply*/
NULL,		                /* notify that get_values called    */
XtInheritAcceptFocus,           /* assign input focus to widget     */
XtVersion,	                /* version of intrinsics used       */
NULL,		                /* list of callback offsets         */
// translations,	        /* state machine                    */
NULL,                           /* state machine                    */
XtInheritQueryGeometry,         /* return preferred geometry        */
XtInheritDisplayAccelerator,    /* display your accelerator         */
NULL		                /* pointer to extension record      */
}
/* PIXtBase */
,{   NULL }

};

WidgetClass piXtBaseWidgetClass = (WidgetClass) &piXtBaseClassRec;


static Time last_time_xevt = 0;
static unsigned long last_serial_xevt = 0;

Time PIXGetLastEventTime() { return(last_time_xevt); }
unsigned long PIXGetLastEventSerial() { return(last_serial_xevt); }

/* Nouvelle-Fonction */
static void init_class_pixtbase()
{
#ifdef DEBUG_PIXTB
puts("Debug_init_class_pixtbase() ");
#endif
return;
}

/* Nouvelle-Fonction */
static void init_pixtbase (Widget request, Widget wdg,
                          ArgList /*args*/, Cardinal* /*narg*/)
{
PIXtBaseWidget wdgp;
wdgp = (PIXtBaseWidget)wdg;

if(request->core.width<=0)  wdgp->core.width  = 10;
if(request->core.height<=0) wdgp->core.height = 10;
// get_GCs (wdgp);
#ifdef DEBUG_PIXTB
printf("Debug_init_pixtbase: Wdg=%lx Object= %lx  narg=%d \n", 
(long)wdgp, (long)(wdgp->pixtbase.objet), (int)(*narg));
#endif
return;
}

/* Nouvelle-Fonction */
static void destroy_pixtbase (Widget /*wdgp*/)
{
#ifdef DEBUG_PIXTB
printf("Debug_destroy_pixtbase: Wdg= %lx Object= %lx \n", (long)wdgp, 
(long)(((PIXtBaseWidget)wdgp)->pixtbase.objet) );
#endif
// free_GCs((PIXtBaseWidget)wdgp);
//    $CHECK$ Reza  21/11/97
// J'ai l'impression que cette fonction n'est pas appellee au moment 
// de destruction du Widget - Par contre la fonction leave est appelee
// si l'action correspondante a ete enregistree ?!
}


/* Nouvelle-Fonction */
static void resize_pixtbase (Widget wdgp)
{
#ifdef DEBUG_PIXTB
printf("Debug_resize_pixtbase: Wdg=%lx Object= %lx \n", (long)wdgp, 
(long)(((PIXtBaseWidget)wdgp)->pixtbase.objet) );
#endif
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Resize();
return;
}

/* Nouvelle-Fonction */
static void expose_pixtbase (Widget  wdgp, XEvent* /*event*/, Region region)
{
#ifdef DEBUG_PIXTB
printf("Debug_expose_pixtbase: Wdg=%lx Object= %lx \n", (long)wdgp, 
(long)(((PIXtBaseWidget)wdgp)->pixtbase.objet) );
#endif

if ( ((PIXtBaseWidget)wdgp)->pixtbase.objet ) 
  {
  XRectangle  xrec;
  int x0, y0, dx, dy;
  XClipBox(region, &xrec);
  x0 = xrec.x;  y0 = xrec.y;
  dx = xrec.width;  dy = xrec.height;
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Draw(x0, y0, dx, dy);
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->CallDrawers(x0, y0, dx, dy);
  }
return;
}

/* Nouvelle-Fonction */
static void enter_pixtbase (Widget wdgp, XEvent* evt, 
                            String* /*args*/, Cardinal* /*narg*/)
{
#ifdef DEBUG_PIXTB
printf("Debug_enter_pixtbase: Wdg=%lx Object= %lx \n", (long)wdgp, 
(long)(((PIXtBaseWidget)wdgp)->pixtbase.objet) );
#endif
last_time_xevt = evt->xcrossing.time;
last_serial_xevt = evt->xcrossing.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
   (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Enter();
return;
}

/* Nouvelle-Fonction */
static void leave_pixtbase (Widget wdgp, XEvent* evt, 
                            String* /*args*/, Cardinal* /*narg*/)
{
#ifdef DEBUG_PIXTB
printf("Debug_leave_pixtbase: Wdg=%lx Object= %lx \n", (long)wdgp, 
(long)(((PIXtBaseWidget)wdgp)->pixtbase.objet) );
#endif
last_time_xevt = evt->xcrossing.time;
last_serial_xevt = evt->xcrossing.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
   (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Leave();
return;
}

/* Nouvelle-Fonction */
static void bud1_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)

{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->But1Press(x,y);
  }
return;
}

/* Nouvelle-Fonction */
static void buu1_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)

{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->But1Release(x,y);
  }
return;
}
/* Nouvelle-Fonction */
static void bud2_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)

{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->But2Press(x,y);
}
return;
}

/* Nouvelle-Fonction */
static void buu2_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)
{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet)
  { 
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->But2Release(x,y);
  }
return;
}


/* Nouvelle-Fonction */
static void bud3_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)

{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->But3Press(x,y);
}
return;
}

/* Nouvelle-Fonction */
static void buu3_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)

{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet) 
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->But3Release(x,y);
}
return;
}

/* Nouvelle-Fonction */
static void mov1_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)
{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet)  
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Ptr1Move(x,y);
  }
return;
}

/* Nouvelle-Fonction */
static void mov2_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)
{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet)  
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Ptr2Move(x,y);
  }
return;
}

/* Nouvelle-Fonction */
static void mov3_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)
{
last_time_xevt = evt->xbutton.time;
last_serial_xevt = evt->xbutton.serial;
if (((PIXtBaseWidget)wdgp)->pixtbase.objet)  
  {
  int x,y;
  x = evt->xbutton.x;
  y = evt->xbutton.y;  
  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Ptr3Move(x,y);
  }
return;
}

/* Nouvelle-Fonction */
static void keyb_pixtbase (Widget wdgp, XEvent* evt, 
                           String* /*args*/, Cardinal* /*narg*/)
{
last_time_xevt = evt->xkey.time;
last_serial_xevt = evt->xkey.serial;

if (((PIXtBaseWidget)wdgp)->pixtbase.objet)  
  {
  XComposeStatus cs;
  KeySym key;
  char buf[10];
  int i,nc,rkey;
  PIKeyModifier kmod;
  
  kmod = PIKM_Blank;
  nc = XLookupString(&(evt->xkey), buf, 10, &key, &cs);

  if  (evt->xkey.state & ShiftMask)   
    kmod = (PIKeyModifier) (kmod | PIKM_Shift);
  if  (evt->xkey.state & ControlMask) 
    kmod = (PIKeyModifier) (kmod | PIKM_Cntl);
  if  (evt->xkey.state & Mod1Mask)    
    kmod = (PIKeyModifier) (kmod | PIKM_Alt);
  switch (key) {
    case XK_Return :
      rkey = PIK_Return;
      break;
    case XK_KP_Enter :
      rkey = PIK_Enter;
      break;
    case XK_Up :
      rkey = PIK_Up;
      break;
    case XK_Down :
      rkey = PIK_Down;
      break;
    case XK_Left :
      rkey = PIK_Left;
      break;
    case XK_Right :
      rkey = PIK_Right;
      break;
    case XK_Prior :
      rkey = PIK_Previous;
      break;
    case XK_Next :
      rkey = PIK_Next;
      break;
    default :
      rkey = 0;
      break;
  }
  if (rkey > 0)  (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Keyboard(rkey, kmod);
  else for(i=0; i<nc; i++)  
    (((PIXtBaseWidget)wdgp)->pixtbase.objet)->Keyboard((int)(buf[i]), kmod);
}
return;
}


/* Nouvelle-Fonction 
static void get_GCs (PIXtBaseWidget wdgp)
{

XGCValues       values;
XtGCMask        mask;
Display *dpy;

dpy = XtDisplay(wdgp);

mask              = GCForeground | GCBackground ;
values.foreground = WhitePixel(dpy, XDefaultScreen(dpy));
values.background = BlackPixel(dpy, XDefaultScreen(dpy));
wdgp->pixtbase.defgc      = XtGetGC((Widget) wdgp, mask, &values);
return;
}
*/

/* Nouvelle-Fonction 
static void free_GCs (PIXtBaseWidget wdgp)
{
XtReleaseGC ((Widget) wdgp, wdgp->pixtbase.defgc);
}

*/

