#  SKYMIX  NbComponents  NSide_HealPix
SKYMIX  3  128

#  READMAP  FitsName
#  To Read the already prepared (mixed) Output MAP from FITS file
#  FitsName should be the complete path to the FITS file
READMAP xxx.fits

#  Defining the Detection filter pass - band
#  GAUSSFILTER or FILTERFITSFILE  card
#  GAUSSFILTER -> Gaussian filter
#  FILTERFITSFILE -> Filter (nu, T(nu)) from FITS file
#  GAUSSFILTER  Nu0 Sigma_Nu Tmax NuMin NuMax
#  FILTERFITSFILE FileName NuMin NuMax
#       FileName should be a complete path
@GAUSSFILTER 143 12 0.84 50. 300.

#  MAPPATH  PathForFITS   
#  path for input Sky Component FITS files , and EmissionSpectra files 
MAPPATH /data/opus/Rz/SOPHYA/


#  ----        Sky components  ---------
#      ----     HealPix maps   ----
#  MAPFITSFILEi FITSfilename Normalisation
@MAPFITSFILE1  gauss.fits  1.0 

#      ---   Emission Spectra definition -----
#   SPECTRAFITSFILEi  FITSfilename  Fmin Fmax 
@SPECTRAFITSFILE1  pl.fits 100 600  

#   Other possible definition of emission spectra
#   BLACKBODYi  temperature
#  The blackbody object returns flux in units of watt/m2/sr/hz
#   We thus scale the map (x 1.e17) 
@MAPFITSFILE2  cossin.fits  1.e17 
@BLACKBODY2 2.726

#   For power-law spectra  f = a ((nu-nu0)/dnu)^b)
#   POWERLAWSPECTRAi  a nu0 dnu b Fmin Fmax
@MAPFITSFILE3  noise.fits    0.1 
@POWERLAWSPECTRA3 1. 150. 50. -0.5 100. 500.

#  Define the Debug level
@DEBUGLEVEL  0
#  Define the Print level
@PRINTLEVEL  5
