// sststarfinder.cc
// Eric Aubourg & Dominique Yvon        CEA/DAPNIA/SPP   octobre 1999

#include "sststarfinder.h"
#include "pisteetoile.h"
#include "toimanager.h"
#include "archparam.h"

ofstream SSTStarFinder::sstchass("SSTChassLogFile");
bool     SSTStarFinder::sstchassinit=false;

#define sstStarCount "sstStarCount"
#define sstStarZ     "sstStarZ"
#define sstStarF     "sstStarF"
#define sstStarSN    "sstStarSN"
#define sstStarUTC   "sstStarUTC"

bool  SSTStarFinder::has2bars=false;
int   SSTStarFinder::elecOffset=0;



SSTStarFinder::SSTStarFinder() {
  lastFedSample = -1;
  lastAnaSample = -1;
  lastContSample = -1;
  lastKeptSample = -1;
    
  findStarConstruct();
  
  TOIProducer* prod = TOIManager::findTOIProducer(TOI("sstDiode",0));
  if (!prod) {
    cerr << "SSTStarFinder : cannot find producer for sstDiode" << endl;
    exit(-1);
  }
  
  sstprod = dynamic_cast<TOILLSSTProducer*>(prod);
  if (!sstprod) {
    cerr << "SSTStarFinder : producer for sstDiode is not a TOILLSSTProducer" << endl;
    exit(-1);
  }
  
  sstprod->registerProcessor(this);

  possibleTOIs.insert(TOI(sstStarCount,   TOI::all, "", "integer"));  
  possibleTOIs.insert(TOI(sstStarZ,       TOI::all, "", "integer"));  
  possibleTOIs.insert(TOI(sstStarF,       TOI::all, "", "ADU"));  
  possibleTOIs.insert(TOI(sstStarSN,      TOI::all, "", "samplenum"));  
  possibleTOIs.insert(TOI(sstStarUTC,     TOI::all, "", "hours"));  

}

SSTStarFinder::~SSTStarFinder(){
  findStarDestruct();
}

string SSTStarFinder::getName() {
  return("SSTStarFinder 1.0");
}

void SSTStarFinder::addTOI(TOI& toi, TOIAbsorber* client) {
  TOIProducer::addTOI(toi, client);
  TOIManager::activateLLProducer(sstprod);
}

void SSTStarFinder::Has2Bars(bool has, int eo)
{
  has2bars = has;
  elecOffset = eo;
}

#ifdef SSTStatLog
	static ofstream sststat("SSTStatLog");
	static int compteurBlock=0;
	static int nbStar=0;
	#include "ssthardware.h"
	#include "archparam.h"
#endif

void SSTStarFinder::findStarConstruct() {
	PisteBar=new PisteEtoile*[NbPhotDiodBarette];
	for(int i=0; i<NbPhotDiodBarette; i++) PisteBar[i]=new PisteEtoile(i);
	StarHistoryMap.clear();
	if (!sstchassinit) {
	  sstchass<<SSTEtoile::printHeader()<<endl;
	  sstchassinit = true;
	}
}

void SSTStarFinder::findStarDestruct() {
	for(int i=0; i<NbPhotDiodBarette; i++) {
		delete PisteBar[i];
	}
	delete[] PisteBar;
}

void SSTStarFinder::dataFeed(long sampleNum, int* diodeSignal) {
  if (producedTOIs.empty() && processors.empty()) return;
  if (sampleNum == lastFedSample+1) {
	for(int i=0;i<NbPhotDiodBarette; i++) {	
      PisteBar[i]->push(diodeSignal+i,1);
    }
    lastFedSample++;
  } else {
	for(int i=0;i<NbPhotDiodBarette; i++) {	
      PisteBar[i]->fill(diodeSignal+i,sampleNum,1);
    }
    lastFedSample = lastContSample = sampleNum;
  }
  
  if ((sampleNum >= lastAnaSample+8) && (sampleNum - lastContSample >= 40)) {
    lastAnaSample = sampleNum;
    if (lastKeptSample<0) lastKeptSample = sampleNum-8;
	for(int i=0;i<NbPhotDiodBarette; i++) {	
      if (PisteBar[i]->traque()) {				// On a trouve!
        SSTEtoile star = PisteBar[i]->DonneEtoile();
        StarHistoryMap[star.TEchan]=star;
        gotStar(star);
      }
    }
  }
}

void SSTStarFinder::registerProcessor(SSTStarProcessor* p) {
  processors.push_back(p);
  TOIManager::activateLLProducer(sstprod);
}

int SSTStarFinder::getNumbStar(int iSampl) {
	StarHistIter IterLow=StarHistoryMap.lower_bound((double)iSampl);
	StarHistIter IterHigh=StarHistoryMap.upper_bound((double)(iSampl+1.));
	int Compteur=0;
	while (!(IterLow==IterHigh)) {IterLow++; Compteur++;}
	return Compteur;
}

double SSTStarFinder::getStarF(int iSampl, int istar){ 
	if( (getNumbStar(iSampl)==0)||(getNumbStar(iSampl)<=istar)) return -1;
	else {
		StarHistIter IterLow=StarHistoryMap.lower_bound((double)iSampl);
		while(!(istar==0)) {
			IterLow++;
			istar--;
		}
	return (double) ((*IterLow).second).InpCurrent;
	}
}


int SSTStarFinder::getStarZ(int iSampl, int istar) {
	if( (getNumbStar(iSampl)==0)||(getNumbStar(iSampl)<=istar)) return -1;
	StarHistIter IterLow=StarHistoryMap.lower_bound((double)iSampl);
	while(!(istar==0)) {
		IterLow++;
		istar--;
	}
	return ((*IterLow).second).NoDiode;
}

double SSTStarFinder::getStarTime(int iSampl, int istar) {
	if( (getNumbStar(iSampl)==0)||(getNumbStar(iSampl)<=istar)) return -1;
	StarHistIter IterLow=StarHistoryMap.lower_bound((double)iSampl);
	while(!(istar==0)) {
		IterLow++;
		istar--;
	}
	return ((*IterLow).second).TEchan;
}


void SSTStarFinder::gotStar(SSTEtoile const& star) {
  for (vector<SSTStarProcessor*>::iterator i = processors.begin(); 
       i != processors.end(); i++) {
      (*i)->dataFeed(star);    
  }
}


// $CHECK$ we handle correctly only the first star
long SSTStarFinder::firstSampleNum(TOI const&) {
  if (StarHistoryMap.empty()) return -1;
  StarHistIter i = StarHistoryMap.begin();
  return long(floor((*i).second.TEchan));
}

long SSTStarFinder::lastSampleNum(TOI const&) {
  if (StarHistoryMap.empty()) return -1;
  StarHistIter i = StarHistoryMap.end();
  i--;
  return long(floor((*i).second.TEchan));
}
  
bool SSTStarFinder::canGetValue(long sampleNum, TOI const& toi) {
  if (sampleNum < lastKeptSample) return false;
  if (sampleNum > lastAnaSample) return false;
  if (toi.name == sstStarCount) return true;
  if (getNumbStar(sampleNum) > toi.index) return true;
  return false;
}

// $CHECK$ not done properly, complicated !!!
bool SSTStarFinder::canGetPrevValue(long sampleNum, TOI const& toi) {
  return canGetValue(sampleNum-1, toi);
}

bool SSTStarFinder::canGetNextValue(long sampleNum, TOI const& toi) {
  return canGetValue(sampleNum+1, toi);
}

bool SSTStarFinder::canGetValueLater(long sampleNum, TOI const&) {
  return sampleNum > lastAnaSample;
}
  
double SSTStarFinder::getPrevValue(long& sampleNum, TOI const& toi) {
  return getValue(--sampleNum, toi);
}

double SSTStarFinder::getNextValue(long& sampleNum, TOI const& toi) {
  return getValue(++sampleNum, toi);
}

double SSTStarFinder::getValue(long sampleNum, TOI const& toi) {
  if (sampleNum < lastKeptSample) return -1;
  if (sampleNum > lastAnaSample) return -1;
  if (toi.name == sstStarCount) {
    return getNumbStar(sampleNum);
  }
  if (toi.name == sstStarF) {
    return getStarF(sampleNum, toi.index);
  }
  if (toi.name == sstStarZ) {
    return getStarZ(sampleNum, toi.index);
  }
  if (toi.name == sstStarSN) {
    return getStarTime(sampleNum, toi.index);
  }
  if (toi.name == sstStarUTC) {
    return archParam.acq.SN2UTC(getStarTime(sampleNum, toi.index));
  }

  return -1;
}

long SSTStarFinder::wontNeedEarlier(TOI const& toi, TOIAbsorber* client, long t) {
  long oldT = lastNeededSample[toi.ref][client];
  if (t<oldT) return -1;
  lastNeededSample[toi.ref][client] = t;
  map<TOIAbsorber*, long> m = lastNeededSample[toi.ref];
  long min=999999999L;
  for (map<TOIAbsorber*, long>::iterator i = m.begin(); i != m.end(); i++) {
    if ((*i).second < min) min = (*i).second;
  }
  while(!StarHistoryMap.empty() && (*StarHistoryMap.begin()).first < min) StarHistoryMap.erase(StarHistoryMap.begin());
  lastKeptSample=min;
  return min;
}
