#include <manip.h>
#include "compress.h"


/*******************************************************************************************/
/****************   			 											****************/
/****************   			 		compress_3							****************/
/****************   			 											****************/
/*******************************************************************************************/

void  com_3(long val,long* in,long*out,int n,int pasin);


#define kmax_	15		/*  valeur maximum de l'exposant	*/
#define	kmak_	0xf		/*	masque pour l'exposant		*/
#define	emak_	0x7		/*	masque pour l'ecart		*/		
#define	sgbi_	0x4		/*	bit de signe de l'ecart		*/
#define	sign_	0xfffffff8	/*	masque de signe de l'ecart	*/

/*  compress un tableau in de n*9 points dispos avec un pas pasin		*/
/*  les data compresses sont ecrites dans le tableau out de n points	*/
/*  la valeur val est la valeur de reference du point origine			*/


/*  comprime	9*n points  : 1er point dans 1er mot, tous les ecarts dans les n mots suivants		*/ 
/*	9*n	==>	n+1	    pour  72 points :   9 mots			*/

void compress_3_1(long* in,long*out,int n,int pasin)
{
long val;
val=in[0]; out[0]=val;
com_3(val,in,out+1,n/9,pasin);
}



void  com_3(long val,long* in,long*out,int n,int pasin)
{
int filtre[16]={0xffffffff,0xfffffffe,0xfffffffc,0xfffffff8,
				0xfffffff0,0xffffffe0,0xffffffc0,0xffffff80,
				0xffffff00,0xfffffe00,0xfffffc00,0xfffff800,
				0xfffff000,0xffffe000,0xffffc000,0xffff8000};
int test[16]=  {0x00000000,0x00000001,0x00000002,0x00000004,
				0x00000008,0x00000010,0x00000020,0x00000040,
				0x00000080,0x00000100,0x00000200,0x00000400,
				0x00000800,0x00001000,0x00002000,0x00004000};

long val1;
long ec1,ec2,ec3,ec4,ec5,ec6,ec7,ec8,ec9;
int i,k,k1;long q;


for(i=0;i<n;i++)
	{
	k=0;q=3;	/* 3 bit = 7 = +-3	*/

	ec1=in[i*9*pasin]-val;
	shif(ec1,k,q);
	val1=val + arrondi(ec1,k);
	
	k1=k;
	ec2=in[(i*9+1)*pasin]-val1;
	shif(ec2,k,q);
	
	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k);}
	val1+= arrondi(ec2,k);

	ec3=in[(i*9+2)*pasin]-val1;
	shif(ec3,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k);}
	val1+= arrondi(ec3,k);		

	ec4=in[(i*9+3)*pasin]-val1;
	shif(ec4,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k);}
	val1+= arrondi(ec4,k);		

	ec5=in[(i*9+4)*pasin]-val1;
	shif(ec5,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k) + arrondi(ec4,k);}
	val1+= arrondi(ec5,k);		
	
	ec6=in[(i*9+5)*pasin]-val1;
	shif(ec6,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k)
					 + arrondi(ec4,k) + arrondi(ec5,k);}
	val1+= arrondi(ec6,k);		
	
	ec7=in[(i*9+6)*pasin]-val1;
	shif(ec7,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) 
				+ arrondi(ec3,k) + arrondi(ec4,k) + arrondi(ec5,k) + arrondi(ec6,k);}
	val1+= arrondi(ec7,k);		
	
	ec8=in[(i*9+7)*pasin]-val1;
	shif(ec8,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k)
					 + arrondi(ec4,k) + arrondi(ec5,k) + arrondi(ec6,k) + arrondi(ec7,k);}
	val1+= arrondi(ec8,k);		
	
	ec9=in[(i*9+8)*pasin]-val1;
	shif(ec9,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);	*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;
	ec5 =  arrondi(ec5,k) >> k;
	ec6 =  arrondi(ec6,k) >> k;
	ec7 =  arrondi(ec7,k) >> k;
	ec8 =  arrondi(ec8,k) >> k;
	ec9 =  arrondi(ec9,k) >> k;

	out[i]= ((ec1&emak_)<<29) | ((ec2&emak_)<<26) | ((ec3&emak_)<<23) 
				| ((ec4&emak_)<<20) | ((ec5&emak_)<<17) | ((ec6&emak_)<<14)
				| ((ec7&emak_)<<11)  | ((ec8&emak_)<<8) | ((ec9&emak_)<<5) | k ;


/*	if(i<30)  printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	val+= ( (ec1 + ec2 + ec3 + ec4 + ec5 + ec6 + ec7 + ec8 + ec9 ) << k );
	}
}



/*******************************************************************************************/
/****************   			 											*****************/
/****************   			 		compress_4							*****************/
/****************   			 											*****************/
/*******************************************************************************************/

void  com_4(long val,long* in,long*out,int n,int pasin);
void  com_4_paire(long val1,long val2,long* in,long*out,int n,int pasin);


#undef kmax_
#undef	kmak_
#undef	emak_		
#undef	sgbi_
#undef	sign_


#define kmax_	15		/*  valeur maximum de l'exposant	*/
#define	kmak_	0xf		/*	masque pour l'exposant		*/
#define	emak_	0xf		/*	masque pour l'ecart		*/		
#define	sgbi_	0x8		/*	bit de signe de l'ecart		*/
#define	sign_	0xfffffff0	/*	masque de signe de l'ecart	*/

/*  compress un tableau in de n*7 points dispos avec un pas pasin	*/
/*  les data compresses sont ecrites dans le tableau out de n points*/
/*  la valeur val est la valeur de reference du point origine*/


/*  comprime	7*n + 2  points  (de 16 bit chacun)  					*/
/*	1er et 2 eme point dans 1er mot, les ecarts dans les n mots suivants*/ 
/*	7*n + 2	==>	n+1	     ==>   pour  72 points :   11 mots  			*/

void compress_4_1(long* in,long*out,int n,int pasin)
{
long val1,val2;
val1=in[0];val2=in[1];
*out=( (val1<<16) & 0xffff0000 )	|	( ( val2 ) & 0xffff ) ;

com_4(val2,in+2,out+1,n/7,pasin);
}



void  com_4(long val,long* in,long*out,int n,int pasin)
{
int filtre[16]={0xffffffff,0xfffffffe,0xfffffffc,0xfffffff8,
				0xfffffff0,0xffffffe0,0xffffffc0,0xffffff80,
				0xffffff00,0xfffffe00,0xfffffc00,0xfffff800,
				0xfffff000,0xffffe000,0xffffc000,0xffff8000};
int test[16]=  {0x00000000,0x00000001,0x00000002,0x00000004,
				0x00000008,0x00000010,0x00000020,0x00000040,
				0x00000080,0x00000100,0x00000200,0x00000400,
				0x00000800,0x00001000,0x00002000,0x00004000};

long val1;
long ec1,ec2,ec3,ec4,ec5,ec6,ec7;
int i,k,k1;long q;


for(i=0;i<n;i++)
	{
	k=0;q=7;	/* 4 bit = 15 = +-7	*/

	ec1=in[i*7*pasin]-val;
	shif(ec1,k,q);
	val1=val + arrondi(ec1,k);
	
	k1=k;
	ec2=in[(i*7+1)*pasin]-val1;
	shif(ec2,k,q);
	
	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k);}
	val1+= arrondi(ec2,k);

	ec3=in[(i*7+2)*pasin]-val1;
	shif(ec3,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k);}
	val1+= arrondi(ec3,k);		

	ec4=in[(i*7+3)*pasin]-val1;
	shif(ec4,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k);}
	val1+= arrondi(ec4,k);		

	ec5=in[(i*7+4)*pasin]-val1;
	shif(ec5,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k) + arrondi(ec4,k);}
	val1+= arrondi(ec5,k);		
	
	ec6=in[(i*7+5)*pasin]-val1;
	shif(ec6,k,q);

	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k)
					 + arrondi(ec4,k) + arrondi(ec5,k);}
	val1+= arrondi(ec6,k);		
	
	ec7=in[(i*7+6)*pasin]-val1;
	shif(ec7,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;
	ec5 =  arrondi(ec5,k) >> k;
	ec6 =  arrondi(ec6,k) >> k;
	ec7 =  arrondi(ec7,k) >> k;

	out[i]= ((ec1&emak_)<<28) | ((ec2&emak_)<<24) | ((ec3&emak_)<<20) 
				| ((ec4&emak_)<<16) | ((ec5&emak_)<<12) | ((ec6&emak_)<<8) | ((ec7&emak_)<<4) | k ;


/*	if(i<30)  printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	val+= ( (ec1 + ec2 + ec3 + ec4 + ec5 + ec6 + ec7 ) << k );
	}
}

/********************************************************************************************/

/*  compresse en 4 bit mais par paire (pour data provenant de la detection synchrone)		*/

/*     21 bit maleur maximum			*/
/*  comprime	7*n+2 points  : 1er et 2eme point dans 1er et 2eme mot, suite dans n mots	*/
/*		diffrences entre valeures paires  et entre valeures impaires uniquement			*/ 
/*	7*n+2	==>	n+2			==>  pour 72 points :		12 mots								*/

void compress_4_2(long* in,long*out,int n,int pasin)
{
long val1,val2;
val1=in[0];		val2=in[1];
out[0]=val1;	out[1]=val2;
com_4_paire(val1,val2,in+2,out+2,n/7,pasin);
}


void  com_4_paire(long val1,long val2,long* in,long*out,int n,int pasin)
{
int filtre[16]={0xffffffff,0xfffffffe,0xfffffffc,0xfffffff8,
				0xfffffff0,0xffffffe0,0xffffffc0,0xffffff80,
				0xffffff00,0xfffffe00,0xfffffc00,0xfffff800,
				0xfffff000,0xffffe000,0xffffc000,0xffff8000};
int test[16]=  {0x00000000,0x00000001,0x00000002,0x00000004,
				0x00000008,0x00000010,0x00000020,0x00000040,
				0x00000080,0x00000100,0x00000200,0x00000400,
				0x00000800,0x00001000,0x00002000,0x00004000};

long val1p,val2p;
long ec1,ec2,ec3,ec4,ec5,ec6,ec7;
int i,k,k1;long q;


for(i=0;i<n;i++)
	{
	k=0;q=7;	/* 4 bit = 15 = +-7	*/

	ec1=in[i*7*pasin]-val1;
	shif(ec1,k,q);
	
	ec2=in[(i*7+1)*pasin]-val2;
	shif(ec2,k,q);
	
	k1=k;
	val1p=val1 + arrondi(ec1,k);


	ec3=in[(i*7+2)*pasin]-val1p;
	shif(ec3,k,q);

	val2p=val2 + arrondi(ec2,k);

	ec4=in[(i*7+3)*pasin]-val2p;
	shif(ec4,k,q);

	if(k>k1)	{k1=k;val1p=val1 + arrondi(ec1,k);val2p = val2 + arrondi(ec2,k);}
	
	val1p+= arrondi(ec3,k);		

	ec5=in[(i*7+4)*pasin]-val1p;
	shif(ec5,k,q);

	if(k>k1)	{	k1=k;
				val1p=val1 + arrondi(ec1,k) + arrondi(ec3,k);
				val2p=val2 + arrondi(ec2,k);
				}
	val2p+= arrondi(ec4,k);		
	
	ec6=in[(i*7+5)*pasin]-val2p;
	shif(ec6,k,q);

	if(k>k1)	{	k1=k;
				val1p=val1 + arrondi(ec1,k) + arrondi(ec3,k);
				val2p=val2 + arrondi(ec2,k) + arrondi(ec4,k);
				}
	val1p+= arrondi(ec5,k);		
	
	ec7=in[(i*7+6)*pasin]-val1p;
	shif(ec7,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;
	ec5 =  arrondi(ec5,k) >> k;
	ec6 =  arrondi(ec6,k) >> k;
	ec7 =  arrondi(ec7,k) >> k;

	out[i]= ((ec1&emak_)<<28) | ((ec2&emak_)<<24) | ((ec3&emak_)<<20) 
				| ((ec4&emak_)<<16) | ((ec5&emak_)<<12) | ((ec6&emak_)<<8) | ((ec7&emak_)<<4) | k ;


/*	if(i<30)  printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	val1p = val1 + ( (ec1 + ec3 + ec5 + ec7 ) << k );
	val1= val2 + ( (ec2 + ec4	+ ec6 ) << k );
	val2 = val1p;
	}
}





/*******************************************************************************************/
/****************   			 											*****************/
/****************   			 		compress_7							*****************/
/****************   			 											*****************/
/*******************************************************************************************/


void  compress_7(long val,long* in,long*out,int n,int pasin);
void  compress_7_paire(long val1,long val2,long* in,long*out,int n,int pasin);


#undef kmax_
#undef	kmak_
#undef	emak_		
#undef	sgbi_
#undef	sign_



#define kmax_	15		/*  valeur maximum de l'exposant	*/
#define	kmak_	0xf		/*	masque pour l'exposant		*/
#define	emak_	0x7f		/*	masque pour l'ecart		*/		
#define	sgbi_	0x40		/*	bit de signe de l'ecart		*/
#define	sign_	0xffffff80	/*	masque de signe de l'ecart	*/


/*  comprime	4*n points  : 1er point dans 1er mot, tous les ecarts dans les n mots suivants		*/ 
/*	4*n	==>	n+1	*/

void compress_7_1(long* in,long*out,int n,int pasin)
{
long val;
val=*in;
*out=val;
compress_7(val,in,out+1,n/4,pasin);
}



/*  compress un tableau in de n*4 points dispos avec un pas pasin	*/
/*  les data compresses sont ecrites dans le tableau out de n points	*/
/*  la valeur val est la valeur de reference du point origine	*/

void  compress_7(long val,long* in,long*out,int n,int pasin)
{
int filtre[16]={0xffffffff,0xfffffffe,0xfffffffc,0xfffffff8,
				0xfffffff0,0xffffffe0,0xffffffc0,0xffffff80,
				0xffffff00,0xfffffe00,0xfffffc00,0xfffff800,
				0xfffff000,0xffffe000,0xffffc000,0xffff8000};
int test[16]=  {0x00000000,0x00000001,0x00000002,0x00000004,
				0x00000008,0x00000010,0x00000020,0x00000040,
				0x00000080,0x00000100,0x00000200,0x00000400,
				0x00000800,0x00001000,0x00002000,0x00004000};

long val1;
long ec1,ec2,ec3,ec4;
int i,k,k1;long q;


for(i=0;i<n;i++)
	{
	k=0;q=63;		/* 7 bit ->  127  ->   +-63	*/

	ec1=in[i*4*pasin]-val;
	shif(ec1,k,q);
	val1=val + arrondi(ec1,k);
	
	k1=k;
	ec2=in[(i*4+1)*pasin]-val1;
	shif(ec2,k,q);
	
/*	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k);}	*/
	val1+= arrondi(ec2,k);

	ec3=in[(i*4+2)*pasin]-val1;
	shif(ec3,k,q);

/*	if(k>k1)	{k1=k;val1=val + arrondi(ec1,k) + arrondi(ec2,k);}	*/
	val1+= arrondi(ec3,k);		

	ec4=in[(i*4+3)*pasin]-val1;
	shif(ec4,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);	*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;

	out[i]= ((ec1&emak_)<<25) | ((ec2&emak_)<<18) | ((ec3&emak_)<<11) | ((ec4&emak_)<<4) | k ;

/*	if(i<30)  printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);	*/

	val+= ( (ec1 + ec2 + ec3 + ec4 ) << k );
	}
}


/*******************************************************************************************/

/*  compresse en 7 bit mais par paire (pour data provenant de la detection synchrone      */

/* ne prend que les 21 bit de poid faible dans le mot en entree			*/
/*  comprime	4*n points  : 1er et 2eme point dans 1er mot (16 bit chacun),  suite dans n mots		*/
/*		diffrences entre valeures paires  et entre valeures impaires uniquement			*/ 
/*	4*n	==>	n+1	*/

#define  point_in(i,pasin,n)  (in[(i*4+n)*pasin]&0x1fffff)


void compress_7_2(long* in,long*out,int n,int pasin)
{
long val1,val2;
val1=in[0]&0x1fffe0;val2=in[1]&0x1fffe0;
*out=( (val1<<11) & 0xffff0000 )	|	( (val2 >> 5) & 0xffff ) ;

/*printf("in[0]=%x  val1=%x   //    in[1]=%x   val2=%x  \n",in[0],val1,in[1],val2);
printf("in[2]=%x    in[3]=%x   \n",in[2],in[3]);*/
compress_7_paire(val1,val2,in,out+1,n/4,pasin);
}


void  compress_7_paire(long val1,long val2,long* in,long*out,int n,int pasin)
{
int filtre[16]={0xffffffff,0xfffffffe,0xfffffffc,0xfffffff8,
				0xfffffff0,0xffffffe0,0xffffffc0,0xffffff80,
				0xffffff00,0xfffffe00,0xfffffc00,0xfffff800,
				0xfffff000,0xffffe000,0xffffc000,0xffff8000};
int test[16]=  {0x00000000,0x00000001,0x00000002,0x00000004,
				0x00000008,0x00000010,0x00000020,0x00000040,
				0x00000080,0x00000100,0x00000200,0x00000400,
				0x00000800,0x00001000,0x00002000,0x00004000};

long val1p,val2p;
long ec1,ec2,ec3,ec4;
int i,k;long q;


for(i=0;i<n;i++)
	{
	k=0;q=63;		/* 7 bit ->  127  ->   +-63	*/

	ec1=point_in(i,pasin,0)-val1;
	shif(ec1,k,q);
	
	
	ec2=point_in(i,pasin,1)-val2;
	shif(ec2,k,q);
		
	val1p =val1 + arrondi(ec1,k);

	ec3=point_in(i,pasin,2)-val1p;
	shif(ec3,k,q);

	val2p=val2+ arrondi(ec2,k);

	ec4=point_in(i,pasin,3)-val2p;
	shif(ec4,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);	*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;

	out[i]= ((ec1&emak_)<<25) | ((ec2&emak_)<<18) | ((ec3&emak_)<<11) | ((ec4&emak_)<<4) | k ;

/*	if(i<5)  printf("i=%d  k=%d  ec= %x %x %x %x  out=%x \n",i,k,ec1,ec2,ec3,ec4,out[i]);*/	

	val1+= ( (ec1 + ec3 ) << k );
	val2+= ( (ec2 + ec4 ) << k );
	}
}




