#include "diabolo.h"
#include "bolo.h"
#include "onde.h" 


static long x0=0;

typedef struct
	{
	double tech;		// 	temps d'chantillonage
	double s,f,w;		// 	sigma, frequence, pulsation
	int lg;				//  demi largeur de l'ondelette en points
	double *or;			//	pointeur sur la table contenant l'ondelette (cos)
	double *oc;			//	pointeur sur la table contenant l'ondelette (sin)
	}ondestruct;


void	calonde(void);
void	ondelette(int init,double* y);


ondestruct mononde;


void exec_ondelette(int fen,int item,double valeur,...)
{
static double y[nb_max_bolo];

int  j;

switch(item)
    {
    case ouverture	:	gg->trace_ouvert=gg->trace_ouvert | 8 ;	
						mononde.or=0;
						mononde.oc=0;

    					selectgra(fen);
    					graph->ymin=0;
	   					graph->ymax=1000;
    					graph->ypas=100;
    					strcpy(graph->ytitre,"nV/sqr(Hz)");
    					graph->xmax=200;
    					graph->xpas=20;
						graph->taille_graduations=7;
    					graph->sans_image=1;
//						graph->flag_tracen=0;
//						for(j=0;j<nb_max_bolo;j++)	if(gg->bolo_type[j])	graph->flag_tracen+=(1<<j);
             			
             			ondelette(1,y);
             			
             			
             			break;

    case fermeture :	gg->trace_ouvert=gg->trace_ouvert & (255-8); 		// enleve le 8
             			ondelette(2,y);
    					break;
		
	case ond_sigma :
        
						{
						int i;
						ondelette(1,y);
						efface(fen);
					   	graph->couleur_trace=rouge;
					   	style(fen);
						for(i=0;i<2*mononde.lg;i++)
							{
					   		trace(fen,mononde.tech*i,mononde.or[i]);
					   		}
					   	graph->couleur_trace=bleu;
					   	style(fen);
						for(i=0;i<2*mononde.lg;i++)
							{
					   		trace(fen,mononde.tech*i,mononde.oc[i]);
					   		}
					   	graph->couleur_trace=vert;
					   	style(fen);

						}

						break;

	case ond_frequ:	ondelette(1,y);
					break;
                 
	case ond_raz :	gg->temps_origine=gg->temps_cntl;	efface(fen);
    				break;
                 
                 
	case	0	:	for(j=0;j<nb_max_bolo;j++)	y[j]=xbol(j);
					ondelette(0,y);
					break;
		
	
    default  	:   break;
    }
}


/*

double valtest(int i);
double valtest(int i)
{
double x;
x=random(0);
if( (i>3000) && (i<5000) ) x+=0.5*sin(i*0.5);
if(i>7000)  x*=2;
return(x);
}

*/


void ondelette(int init,double* y)
{
static int mpos;
static double *mm[nb_max_bolo];
static flag_init=0;
int i,j;
double vr,vc;
double x;
static double yo[nb_max_bolo];
if(init)			// init==1 pour initialisation    //  init==2 pour free
	{
	
	if(flag_init==4)	{flag_init=1;for(j=0;j<nb_max_bolo;j++)	if(mm[j]) free(mm[j]);flag_init=0;}

	if( (init==1) && (flag_init==0) )
		{
		flag_init=2;
		mononde.tech=gg->periode_echantillonage;
		mononde.s=litD(fenetre_ondelette,ond_sigma,0);
		mononde.f=litD(fenetre_ondelette,ond_frequ,0);
		calonde();
		for(j=0;j<nb_max_bolo;j++)
			{
			mm[j]=malloc(2*mononde.lg*sizeof(double));
			for(i=0;i<2*mononde.lg;i++)	mm[j][i]=0;
			yo[j]=0;
			}
		mpos=0;
		flag_init=4;
		}
	}

if ( (!init) && (flag_init==4) )
	{

	for(j=0;j<nb_max_bolo;j++)	mm[j][mpos]=y[j];
						

	if(mpos % (mononde.lg/10) ==0 )
		{
		double filtre;
		filtre=litD(fenetre_ondelette,ond_filtre,0L);
		if(filtre>1) filtre=1./filtre;
		for(j=0;j<nb_max_bolo;j++)
				{	
				vr=0;vc=0;
				for(i=0;i<2*mononde.lg;i++)
					{
					vr+=mm[j][mpos]*mononde.or[i];
					vc+=mm[j][mpos]*mononde.oc[i];
					mpos++;if(mpos>=2*mononde.lg) mpos=0;
					}

				yo[j]=yo[j]*(1-filtre)+filtre * sqrt(vr*vr+vc*vc)*1000;	// en nV/sqr(Hz)
				}
		x=gg->periode_echantillonage*(double)gg->temps_cntl-gg->temps_origine;
		if(x<0) 		{
				 		graph->xmax-=graph->xmin;graph->xmin=0;
				 		 gg->temps_origine=gg->periode_echantillonage*(double)gg->temps_cntl;	
				 		 x=0;
				 		}
		montracen(fenetre_ondelette,nb_max_bolo,x,yo);
		if(!(graph->scroll_courbe) &&
				 ( (x<graph->xmin) ou (x>graph->xmax) )) 
				 		{
				 		graph->xmax-=graph->xmin;graph->xmin=0;
				 		 gg->temps_origine=gg->periode_echantillonage*(double)gg->temps_cntl;	
				 		 x=0;
				 		}
		}	
	mpos++;if(mpos>=2*mononde.lg) mpos=0;
	}
}


//--------------------  fonction  fabriQUE L'ONDELETTE et fait les malloc  -------------------------------


void calonde(void)
{
double t,a,nbp;
double somme=0,gaus=0,norme=0;
int i;

mononde.w=2*3.14159*mononde.f;		// w en unite de point
mononde.lg=mononde.s*5./(mononde.w*mononde.tech); 
if(mononde.or) free(mononde.or);
if(mononde.oc) free(mononde.oc);
mononde.or=malloc(2*mononde.lg*sizeof(double));
mononde.oc=malloc(2*mononde.lg*sizeof(double));

for(i=0;i<2*mononde.lg;i++)
	{
	t=mononde.tech*(i-mononde.lg)*mononde.w;
	a=t/mononde.s;a=exp (-a*a/ 2.);
	mononde.or[i]=a  * cos(t);
	mononde.oc[i]=a  * sin(t);
	somme+=mononde.or[i];
	norme+=a*a;
	gaus+=a;
	}
somme=somme/gaus;
nbp=1/sqrt(norme);
printf("normalisation: somme=%g  gaus=%g \n",somme,gaus);
nbp*=sqrt(2*mononde.tech);		// dpendance avec la frequence d'chantillonage
//  en mettant 2* le temps d'chantillonage, on amliore la correspondance avec le spectre RMS
for(i=0;i<2*mononde.lg;i++)	
	{
	t=mononde.tech*(i-mononde.lg)*mononde.w;
	a=t/mononde.s;a=exp (-a*a/ 2.);
	mononde.or[i]-=a*somme;
	mononde.or[i]*=nbp;
	mononde.oc[i]*=nbp;
	}
}



