#include "diabolo.h" 
#include "senseur_stellaire.h" 



//--------------------  fonction  exec  de  la  fenetre : senseur_stellaire  -------------------------------


void exec_senseur_stellaire(int fen,int item,double valeur,...) 
{
if(item>1000) item-=1000;		// pour appeler le case pour tous les cara d'un edit texte

switch(item)
    {
    case ouverture               :
    			
                 break;
    case fermeture               :
                 break;
    case sst_azer :
                 break;
    case sst_sortie_brute :
                 break;
    default  :   break;
    }
}

//#define	bit_sst(i,j,k)  (((blk->sst[i][i*3+k/4])>>(j+8*k%4))&1)   


//   i est le numero du point dans le block de 72
//	j	est le numero de la diode  de 0 a 47
//  	j%8	est la place du bit dans le mot de 8 bit 
//	j/8	(de 0 a 5 ) est la serie de mesure
//	k est le numero du bit dans le mot de 12 bits
//		les k se suivent dans les donnes

//   k est le numero du point dans le block de 72
//	i	est le numero de la diode  de 0 a 47
//  	j	est le paquet de 4 bits de 0 a 2 


// on prend des paquets de 4 bits
// chaque diode est formee de 3 paquets
// dans l'ordre :  les paquets de 8 diodes  (8 paquets)
//  recommencer 3 fois	(24 paquets)
// enfin, faire 6 fois cette operation  (144 paquets)

// soit q  la place du paquet  i,j,k
#define place_paquet(i,j)	 (i/8) * 24  + j*8 + (i%8) 


void	traite_block_sst(block_type_sst*	blk)
{
int i,j,k;
double	y[15];
double	x;

int temps_cntl;
double secondes;
int a,b,b0,b1,b2;

if(!fenetre(fenetre_senseur_stellaire)) return;
//  ecriture des valeurs brutes du senseur stellaire
//  les numero 0 et 4  sont dedis aux thermometres
//  pour l'instant machent bien 1 2 3   8 9 10 11   
if(litD(fenetre_senseur_stellaire,sst_sortie_brute,0))
	{
	if(!fenetre(fenetre_senseur_stellaire_lecture_brute)) nouveauT(fenetre_senseur_stellaire_lecture_brute,0,"lecture senseur stellaire");

	ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"\nsenseur stellaire  \n");


//	k=0;
	for(k=0;k<4;k++)
		{
	    	for(i=0;i<16;i++)		//  16 senseurs 
			{
			for(j=0;j<3;j++)		//  3 paquets
	    			{
	    			a=place_paquet(i,j);
	    			b= ( blk->sst[k][a/8] >>( (a%8)*4) ) & 0xf;
				ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"%x",b);
				}
			ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"  ");
			}
	 	ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"\n");
	 	}

	 ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"\n");

	 }


//k=0;
for(k=0;k<72;k++)
	{
	 for(i=0;i<12;i++)		//  seulement les 8 premieres diodes 
		{
		int q;
		q=i+4;
		if(i>3 ) q=i+8;
		if(i>7 ) q=i+12;
		
		a=place_paquet(q,0);
	    	b0= ( blk->sst[k][a/8] >>( (a%8)*4) ) & 0xf;
		a=place_paquet(q,1);
	    	b1= ( blk->sst[k][a/8] >>( (a%8)*4) ) & 0xf;
		a=place_paquet(q,2);
	    	b2= ( blk->sst[k][a/8] >>( (a%8)*4) ) & 0xf;
		

		x=(double)( (b0<<8) | (b1<<4) |  b2 ) ;
		if(x>2047) x-=4096;
		y[i]=x;
		}
//	printf(" y = %g %g %g %g %g \n",y[0],y[1],y[2],y[3],y[4]);
	temps_cntl =numero_block(blk)*nb_per_block*2+k;
	secondes=gg->periode_echantillonage*(double)temps_cntl-gg->temps_origine;
	tracen(fenetre_senseur_stellaire,12,secondes,y);
	}
}


		
//	les 46 valeurs en hexa
//	i=0;			//  juste le premier point du block
//	for(i=0;i<72;i++)
/*
for(i=0;i<72;i++)
	{

	 for(j=0;j<12;j++)		//  seulement les 12 premieres diodes 
		{
		x=0;
		for(k=0;k<12;k++)	x=(x<<1)  | bit_sst(i,j,k);
		y[j]=(double)x;
		}
	temps_cntl =numero_block(blk)*nb_per_block*2+i;
	secondes=gg->periode_echantillonage*(double)temps_cntl-gg->temps_origine;
	tracen(fenetre_senseur_stellaire,12,secondes,y);
	}
			
*/
/*	i=1;			//  juste le premier point du block
//	for(i=0;i<72;i++)
		{
		for(k=0;k<12;k++)		//  12 bits
	    		{
	    		for(j=0;j<35;j++)		//  46 senseurs 
				{
				ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"%d   ",bit_sst(i,j,k));
				}
	 		ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"\n");
			}
	 	ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"\n");
	 	}
		
//	les 46 valeurs en hexa
//	i=0;			//  juste le premier point du block
//	for(i=0;i<72;i++)
	for(i=0;i<10;i++)
		{
	    	for(j=0;j<35;j++)		//  46 senseurs 
			{
			x=0;
			for(k=0;k<12;k++)	x=(x<<1)  | bit_sst(i,j,k);
			ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"%3x ",x);
			}
	 	ecritT(fenetre_senseur_stellaire_lecture_brute,fin_f,"\n");
	 	}
			
	
	}

			
*/	
