#include "diabolo.h"
#include "bolo.h"
#include "acqui.h"
#include "carte_acqui.h"
#include "carte_pci.h"
#include "trace.h"
#include "corel.h" 
#include "montimer.h"
#include "synchro.h"
#include "fichier.h"
#include "onde.h"
#include "tm.h"
#include "tache.h"
#include "compress.h"
#include "controle.h"



#define temps_timer 10		//  10 ms  donc 2500 points pour  4sec ( fifo 32k )

tmtc*	tt;			// pointeur global  sur la structure tmtc 



#define max_couleur 10
int 	bolo_couleur[max_couleur];		//  les numero de bolos des 10 couleurs affiches
#define perm(a)	{if(fenetre(a)) permanent(a);}


//  programme d'acquisition: affichage des rsultats en tache de fond tous les 10 ticks (6 fois/seconde) 



void acqui(int fen,int item,double valeur,...)
{
int q;
static int acquisition=0;
static int count=0;
static int nberr=0;
static double x_err,errmoy;
static int count_moy_err=0;
int err;

if	(item!=tache_de_fond)		return;
if	(gg->depou_en_cours)		return;

gg->depou_en_cours=1;

/*
{  //  test par envoie continue d'un changement de frequence
static qq=0;
qq++;
if(qq==10)	{ecritD(fenetre_acquisition,e_periode,"4");	calfreq(0);}
if(qq==20)	{qq=0;ecritD(fenetre_acquisition,e_periode,"8");	calfreq(0);}
}
*/

if( count-- < 0 ) 
		{
		count=3; 
		ecritD(fenetre_controle,con_retard1,"%d",tt->nb_lec_fofo_ext);
		tt->nb_lec_fofo_ext=0;
		}


err=test_erreur();  //______________   test des erreurs   _______________________________


//_____________________   lit la table tlmesure  ______________________________________
  					


q=(longueur_table_tm+tt->tm.pos_ecrit-tt->tm.pos_lit)%longueur_table_tm;

while(q)
	{
	ecritD(fenetre_controle,con_retard2,"%d",(longueur_table_tm+tt->tm.pos_ecrit-tt->tm.pos_lit)%longueur_table_tm);

//*****************************************************************************************
//											***
#ifdef _archeops	//---------   pour  Archeops    -----------------------------	***
lit_block_archeops(err);
#endif
#ifdef _diabolo		//---------   pour  Diabolo    ------------------------------	***
lit_block_diabolo(err);
#endif			//-----------------------------------------------------------	***
//											***
//*****************************************************************************************
//	printf(" pos=%d \n",tt->tm.pos_lit); 
	tt->tm.pos_lit++;  if(tt->tm.pos_lit>=longueur_table_tm) tt->tm.pos_lit-=longueur_table_tm;	
	q--;
	}
//________________________________________________________________________________________

gg->depou_en_cours=0;					
}





void exec_acquisition(int fen,int item,double valeur,...) 
{
//char ss[256];
static TMInfoPtr TTm=0;
int i,j;

switch(item)
	{
	case ouverture	:	gg->flag_tc_reduite=litD(fen,e_tc_reduite,0);
				if(tt->PCI_actif==1) reset_carte;
	   			ecritD(fen,e_tache_inter,0);   	// arreter les interruptions
    				reset_epld();
    				calfreq(0);			// d'abord fixer la frquence
    
	case e_reset       :	reset_epld();	
	
    case e_bolo_couleur :
    case e_bolo_couleur+1 :
    case e_bolo_couleur+2 :
    case e_bolo_couleur+3 :
    case e_bolo_couleur+4 :
    case e_bolo_couleur+5 :
    case e_bolo_couleur+6 :
    case e_bolo_couleur+7 :
    case e_bolo_couleur+8 :
    case e_bolo_couleur+9 :
    
    				for(i=0;i<max_couleur;i++)	
    					{
    					bolo_couleur[i]=litD(fen,e_bolo_couleur+i,0L)-1;
    					if( (bolo_couleur[i]<1) ou (bolo_couleur[i]>nb_max_bolo) )   bolo_couleur[i]=0;
    					printf(" i=%d bolo=%d    ",i,bolo_couleur[i]);
    					}
    				printf("\n");
				break;		
				    
	case e_montre :		for(j=nb_max_bolo-1;j>=0;j--)	if(parametr.bolo[j].bolo_code_util) select(j+1);
				break;
						
	case e_sauve :		for(j=0;j<nb_max_bolo;j++)	if(parametr.bolo[j].bolo_code_util)permanent(j+1);
    				perm(fenetre_acquisition);
    				perm(fenetre_liste_bolos);
//   				perm(fenetre_regul);
//    				perm(fenetre_auto);
   				perm(fenetre_regulation);
    				perm(fenetre_automatismes);
//    				perm(fenetre_dilution);
//    				perm(fenetre_senseur_stellaire);
				break;
						
       
	case e_transmission :	{
				long ll=(long)(&(gg->reglage.dilu.transmission))-(long)(&(gg->reglage.dilu));
    				int a=(int) valeur;	
    				emission_tc_reduite(tc2_auto_dilu,ll,a);
    				}
    				break;

	case e_vanne	: 	{
				long ll=(long)(&(gg->reglage.dilu.vanne))-(long)(&(gg->reglage.dilu));
    				int a=(int) valeur;	
    				emission_tc_reduite(tc2_auto_dilu,ll,a);
    				}
    				break;

	case e_chauf	: 	{
				long ll=(long)(&(gg->reglage.dilu.chauffage))-(long)(&(gg->reglage.dilu));
    				int a=(int) valeur;	
    				emission_tc_reduite(tc2_auto_dilu,ll,a);
    				}
    				break;


	case e_tache_inter :	calfreq(0);	//  command ou arrete le flag epld sortie data
				if(TTm)		stoptimer(TTm);
    				if(tt->PCI_actif==1) reset_carte;
    				tt->vi.a=0;
    				if(valeur) 
    					{
                 			if(!TTm)	TTm=setuptimer(temps_timer,lecture_fifo,tt);	    
                 			else		redemarretimer(TTm,temps_timer);
    					calfreq(1);	//  commande le flag epld sortie data
					}
                 		break;

	case fermeture	:	if(TTm)		stoptimer(TTm);
    				
    				{long t=TickCount()+60; while(t>TickCount()) {};} //attente 1 sec
				
				if(TTm)	supprimetimer(TTm);
   				break;
    

	case caseferme  	:	cache(fen);	stop_exec(fen);	break;
   

	case e_periode+1000	:
	case e_periode		:		// printf("change la priode \n");
	
	case e_nb_mes		:		// printf("change le nombre de mesures \n");
	case e_temp_mort	:
	case e_flag1 		:	  	// passe horloge externe ou local  
	case e_flag2 		:	  	// passe horloge externe ou local  
    					calfreq((int)litD(fen,e_tache_inter,0));
    					break;
    	case e_tc_reduite  :	gg->flag_tc_reduite=valeur;	break;
    				
	case e_correlations :	gg->flag_corel=valeur;		break;


	default  			:	break;
	}
}


//------------------------------   montracen   --------------------------------------


void	montracen(int fen,int n,double x,double*y)
{
int i;
double yy[max_couleur];
for(i=0;i<max_couleur;i++)
	{
	if(bolo_couleur[i])	yy[i]=y[bolo_couleur[i]-1];
		else		yy[i]=0;
	}
tracen(fen,max_couleur,x,yy);
//	printf("0=%g  1=%g  2=%g  \n",yy[0],yy[1],yy[2]);
}

int bolo_rouge(void)		//  l'indice du bolo rouge 
{
return(bolo_couleur[0]);
}

