#include "diabolo.h"
#include "synchro.h"
#include "carte.h"



#define indicemax	1000

double taille_carte,pas,vitesse;
int bolo_carte,indice,ind_moy,debut_ligne,moy,sens_ligne;
double dynamique;
double seuil;

double carte[nb_max_bolo][indicemax];
double	xx[indicemax];
double	yy[indicemax];
int	flag_fin[indicemax],flag_sens[indicemax];

double xx0,yy0;


//--------------------  fonction  exec  de  la  fenetre : trace_carte  -------------------------------
void	echelles(void);
void	retrace_carte(void);

void exec_carte(int fen,int item,double valeur,...) 
{
if(item>1000) item-=1000;		// pour appeler le case pour tous les cara d'un edit texte

switch(item)
	{
	case ouverture     :	gg->trace_ouvert=gg->trace_ouvert | 16 ;	
 	    			selectgra(fen);
    				graph->taille_graduations=7;

	case cart_debut :	echelles();
				indice=0;ind_moy=0;sens_ligne=1;debut_ligne=1;	// premier point a venir
				xx0=-0.5*(taille_carte-0.5*pas);yy0=-0.5*taille_carte;
				break;



	case fermeture     :	gg->trace_ouvert=gg->trace_ouvert & (255-16); 		// enleve le 16
    						break;
   
	case cart_taille_carte :			
	case cart_pas :			
	case cart_dynamique :			
	case cart_bolo :			
	case cart_vitesse :	echelles();		
				
				break;
	
	case cart_retrace :	retrace_carte();
				break;			
	        			
	default  :		break;
	}
}


void echelles(void)
{
double moyenne_double;
taille_carte=litD(fenetre_annexe,cart_taille_carte,0);
pas=litD(fenetre_annexe,cart_pas,0);
vitesse=litD(fenetre_annexe,cart_vitesse,0);
dynamique=litD(fenetre_annexe,cart_dynamique,0);
bolo_carte=litD(fenetre_annexe,cart_bolo,0);
selectgra(fenetre_annexe);
graph->ymin=-0.5*(taille_carte+2*pas);
graph->ymax=0.5*(taille_carte+2*pas);
graph->ypas=pas;
graph->xmin=-0.5*(taille_carte+2*pas);
graph->xmax=0.5*(taille_carte+2*pas);
graph->xpas=pas;
graph->graduations=0;
graph->grille=1;
graph->aspect=-1;
efface(fenetre_annexe);
// moyennes par demi pas en x
moyenne_double= pas * 0.5 /( gg->periode_echantillonage * vitesse );

if(gg->trace_ouvert&32)		moyenne_double/=(double)synchro_periode;	// pour mesure avec Detection synchrone
moy=(int)(moyenne_double+0.5);
if(moy<1) moy=1;
printf("moyennes calculee sur %6.2f points  soit m=%d \n",moyenne_double,moy);
}

void trace_carte(double * y)
{
int j;
// calculer le nombre de points de mesure dans un pas a la vitesse 
//	gg->periode_echantillonage	contient la duree entre deux points de mesure (pour diabolo)

if( (!(gg->don.sync[sync_scan]&&gg->don.sync[sync_subscan])) && (indice==0) ) return; 	

if( (!gg->don.sync[sync_subscan]) && (indice>2) && (debut_ligne<3) ) debut_ligne=2;	// entre deux subscan

if(ind_moy==0)	for(j=0;j<nb_max_bolo;j++)	carte[j][indice]=0;
if(ind_moy<moy)	for(j=0;j<nb_max_bolo;j++)	carte[j][indice]+=y[j];
if(ind_moy<moy+10) ind_moy++;	// pour ne pas continuer a l'infini

if( (ind_moy>=moy) && (indice<indicemax) )
	{
	if(ind_moy==moy)
		{
		int couleur_degrade;
		xx[indice]=xx0;
		yy[indice]=yy0;
		flag_fin[indice]=debut_ligne;
		flag_sens[indice]=sens_ligne;
		for(j=0;j<nb_max_bolo;j++)	carte[j][indice]/=(double)moy;

//		if(debut_ligne==1)	seuil=carte[bolo-1][indice];	// premier point d'une ligne : seuil pour la suite 
		seuil=0;	// pas de seuil: utiliser le filtrage en mode puissance totale
				//  et raz parasite  en mode detection synchrone
		couleur_degrade=1050+(50.*(carte[bolo_carte-1][indice]-seuil)/dynamique);
		if(sens_ligne>0)rectangle(fenetre_annexe,xx0-0.25*pas,yy0-0.5*pas,xx0+0.25*pas,yy0,couleur_degrade);
			else	rectangle(fenetre_annexe,xx0-0.25*pas,yy0,xx0+0.25*pas,yy0+0.5*pas,couleur_degrade);
		if(debut_ligne==1)	
			{
			debut_ligne=0;	// premier point 
			printf(" debut_ligne indice=%d :  x=%g  y=%g   valeur=%g  couleur=%d \n",indice,xx0,yy0,carte[8][indice],couleur_degrade);
			}
		indice++;
		}


	if( (debut_ligne==2) && (!gg->don.sync[sync_scan]) )	
		{
		debut_ligne=3;	// fin de carte
		son(133);
		printf("fin de carte \n\n");
		}

	if(gg->don.sync[sync_subscan])	
		{
		if(debut_ligne==2)	// prepare pour mesure premier point
			{
			sens_ligne=-sens_ligne;
			if(sens_ligne>0) yy0+=pas;
			xx0=-0.5*sens_ligne*(taille_carte-0.5*pas);
			debut_ligne=1;	 ind_moy=0;	// premier point 
			}
		if(!debut_ligne)	// prepare pour mesure point suivant
			{
			xx0+=sens_ligne*0.5*pas;
			if( (xx0<0.5*taille_carte) && (xx0>-0.5*taille_carte) ) ind_moy=0;
			}
		}
	}

}


void	retrace_carte(void)
{
int i,k,kk,couleur_degrade;
double sx,sy,sx2,sxy,n,a,b;		// pour le fit lineaire
efface(fenetre_annexe);
//  calcul dynamique automatique 
dynamique=0.000000001;

for(i=0;i<indice;i+=kk) 
	{			//  une ligne commence en indice==i
				// fit lineaire avec un poid null au milieu  :  y= ax+b
				//  
	//  calcule la droite a soustraire
	sx=0;sy=0;sx2=0;sxy=0;n=0;
	k=0;
	do	{
//		printf(" i=%d  k=%d  carte=%g  \n",i,k,carte[bolo-1][i+k]);
		if( (xx[i+k]>0.25*taille_carte) ou (xx[i+k]<-0.25*taille_carte) )
			{
			n++;
			sx+=xx[i+k];
			sy+=carte[bolo_carte-1][i+k];
			sx2+=xx[i+k]*xx[i+k];
			sxy+=xx[i+k]*carte[bolo_carte-1][i+k];
			}
		k++;
		}
	while ( (k<indice-i) &&  (flag_fin[i+k]!=1) );
	
	kk=k; // kk = longueur de ligne 
	a=(sxy*n-sx*sy)/(sx2*n-sx*sx); b=(sy-a*sx)/n;
//	printf(" une ligne indice i=%d  ligne de %d points a=%g  b=%g \n\n",i,kk,a,b); 
	
	//  soustrait la droite fitte sur la ligne et calcule la dynamique
	for(k=0;k<kk;k++)
		{
		carte[bolo_carte-1][i+k]-=a*xx[i+k]+b;
		
//		printf(" k=%d  carte/fittee=%g  \n",k,carte[bolo_carte-1][i+k]);

		if(dynamique<carte[bolo_carte-1][i+k])  dynamique=carte[bolo_carte-1][i+k];
		if(dynamique<-carte[bolo_carte-1][i+k])  dynamique=-carte[bolo_carte-1][i+k];
		}
	}
	
ecritD(	fenetre_annexe,cart_dynamique,"%g",dynamique);

for(i=0;i<indice;i++)
	{	
	couleur_degrade=1050+(50.*carte[bolo_carte-1][i]/dynamique);
//	printf(" retrace : debut_ligne=%d i=%d :  x=%g  y=%g   valeur=%g  couleur=%d \n",debut_ligne,i,xx0,yy0,carte[8][i],couleur_degrade);
	if(flag_sens[i]>0)	rectangle(fenetre_annexe,xx[i]-0.25*pas,yy[i]-0.5*pas,xx[i]+0.25*pas,yy[i],couleur_degrade);
		else		rectangle(fenetre_annexe,xx[i]-0.25*pas,yy[i],xx[i]+0.25*pas,yy[i]+0.5*pas,couleur_degrade);
	}	
}







