//#define mode  taillesymbole
/*
Le fichier de donnes diabolo est un fichier mac de type 'DIA2' qui contient 
	une suite d'enregistrements.
	
Il commence par une entete correspondant  la structure de type F_entete
	- cette entete contient 

On a ensuite une suite d'enregistrements comportant chacun:
	- une entete partielle avec les parametres de mesure, y compris les parametres DAC
		structure de type F_entete_part
	- une suite de valeur correspondant  chaque point mesur et contenant:
			Le temps calcul
			Les 6 signaux de synchro
			Les voies 1  7 :  5 bolometre + 1 temperature + 1 chauffage regul

*/


enum		{bol,bolxx,chauf,pipo};			//  types de bolometres


#define max_nb_donne	1000L				// nombre maxi de donne dans un bloc du fichier
#define	temps_max_fichier	300				// dure maxi d'un fichier (5 minutes) 



#define		max_nb_mesures		256			// maxi dans une periode de modulation electrique

#define 	nb_ds_table			3			// 4  DS :	-	signal
											//			-	chauffage
											//			-	transitoire
											//		pas de mesure de linarit

#define 	nb_max_bolo			9			//  5 bolo, 1 chauff  1 non util.  (MONTER  11 maxi)
#define		nb_sync				6			//	1 synchro diode + 5 synchro externes


/*
 long_entete 	  		= 272 
 long_entete_part 		= 2128 
 long_donne 	  		= 14 

*/


typedef struct			//  etat de l'ensemble de la manip , aussi pour entete partielle  
	{
	
				long	duree;						// dure d'une periode (en sec)
				short	nb_mesures;					// nombre de mesures dans une periode
				short	temp_mort;					// temps mort pour la detection synchrone numerique

				short	diode_etat;					// etat des diodes
				short	diode_dure;					// duree de periode des diodes

				short	gainbrut[nb_max_bolo];				// valeur du gain cod : (0,1,2,...,15) 
				short	gain[nb_max_bolo];					// valeur du gain en vraies valeurs(1,2,4,8,10,...,8000) 
				short	dac[4][nb_max_bolo];				// les valeurs des DAC 4 voies en entier (0  4095)
				short	phase[nb_max_bolo];					// valeur du dephasage individuel : valeur  0    4

	}
	etat_bolo;



typedef struct	{
				short	version;					// 1 pour cette version du programme
						
				short	long_entete;				// longueur de l'entete	
				short	long_entete_part;			// longueur de l'entete partielle
				short	long_donne;					// longueur d'une ligne de donnes

				unsigned long tempsdebut;			// temps de debut de fichier	
				unsigned long tempsfin;				// temps de fin de fichier
				char commentaires[256];				// commentaires  la main
				} F_entete;	  


typedef struct	
				{
				short	n_ligne_don;				// Nombre de lignes de donn dans cet enregistrement
													// ou    nombre d'octets du commentaire
				short	n_blok;						// numero du blok dans le fichier
				short	change;						// valeur 0 = bloc identique au precedent
													// valeur 1 = bloc modifi
													// valeur 2 = debut de prise de donnees
													// valeur 10 = le block ne contient qu'un commentaire

				short	bololut;					//  bit 0  bit 3  ==1  si les courbes bolo ont ete lues
				} F_block_desc;


typedef struct	
				{

				unsigned long 	temps_controleur_debut;		// en micro/secondes :temps du premier point dans le bloc			
				unsigned long 	temps_controleur_fin;		// en micro/secondes :temps du dernier point dans le bloc			
				
				etat_bolo	eb;
				
				short 	bolo[nb_max_bolo][max_nb_mesures];	//   courbe echantillon d'une mesure
							
				} F_block_param;	  


typedef struct	{
				short	bolo[nb_max_bolo];			 
				char	sync[nb_sync];					// les synchro en cara (6 signaux)
				} F_donne;	  


//__________________________   calcul des valeurs  vraies en micro/volt  ou % de chauffage

#define		xbol(j)		((1e5*(double)gg->don.bolo[j])/(65536.*((double)(gg->eb.gain[j]))))		// en V
#define		xsat(j)		((100.*(double)gg->sat[j])/32768.)										//  0    100% 
#define		xchauf(j)	((100.*(double)gg->don.bolo[j])/32768.)									//  0    100% 
#define		xtrans(j)	((1e5*(double)gg->trans[j])/(65536.*((double)(gg->eb.gain[j]))))										//  0    100% 



