#define   utilitaires_de_block_archeops

#include "diabolo.h"
#include "bolo.h"
#include "acqui.h"
#include "carte_acqui.h"
#include "carte_pci.h"
#include "trace.h"
#include "corel.h" 
#include "montimer.h"
#include "synchro.h"
#include "fichier.h"
#include "onde.h"
#include "tm.h"
#include "tache.h"
#include "compress.h"
#include "controle.h"
#include "menu.h"




//*****************************************************************************************
//											***
#ifdef _archeops	//---------   pour  Archeops    ------------------------------	***
//---------------      lit  block      Archeops    ------------------------------	***
//											***
//*****************************************************************************************


//	la fonction litblock
//	1	elle	lit dans la table de telemesures
//	2	elle	teste le type de block et sa validit (somme des bits et code fin)
//	3 	elle	appelle la fonction de traitement en lui fournissant un pointeur sur le block
//	4	elle 	sauve le block dans le fichier
//	C'est la fonction acqui qui apelle lit_block qui avance le pointeur de la table de telemesures	 


block_type_modele bktm;			// memoire pour block local pour copie lors de la decompression

block_type_synchro_sol	blk_sync2;	// block memoire pour les synchro sol qui seront traites lors
					// de la lecture du block bolo



#define blk_tm  (&tt->tm.btm[tt->tm.pos_lit].tmtrx) 	//  pointeur sur le block tlmesure a lire)

void lit_block_archeops(int err)
{
if(verifie_block_printf(blk_tm))	return;

//{def_nom_block  printf("lit un block %s   N%d   \n",nom_block[type_block(blk_tm)],numero_block(blk_tm));	}				

switch(type_block(blk_tm))
	{	
	case block_param :		break;

	case block_journal :		traite_block_journal((block_type_journal*)blk_tm);		break;

	case block_reglage :		traite_block_reglage((block_type_reglage*)blk_tm);		break;
	
	case block_dilution :		traite_block_dilution((block_type_dilution*)blk_tm);		break;
	
	case block_gps :		traite_block_gps((block_type_gps*)blk_tm);			break;
	
	case block_une_periode :	traite_block_une_periode((block_type_une_periode*)blk_tm);	break;
	
	case block_bolo_comprime :	traite_block_bolo_comprime((block_type_bolo_comprime*)blk_tm);	break;
	
	case block_bolo :		traite_block_bolo((block_type_bolo*)blk_tm);			break;
	
	case block_sst :		traite_block_sst((block_type_sst*)blk_tm);			break;
	
	case block_synchro_sol :	traite_block_synchro_sol((block_type_synchro_sol*)blk_tm);	break;
	
#ifdef	transmet_data_brute
	case block_data_brute :		traite_block_data_brute((block_type_data_brute*)blk_tm);	break;
#endif
	
	default	:   {def_nom_block  printf("block de type  %s  non trait par le programme \n",nom_block[type_block(blk_tm)]);}
					break;
	}
	
ecrit_fichier_ARCH(blk_tm);

}
#undef blk_tm

//*****************************************************************************************
//											***
//		------------------   traitement des blocks	---------------		*** 
//											***
//*****************************************************************************************




//-----------------------------------------------------------------------------------------	
//  -------------     block type 1 : lit le journal     ------------------    ------------
//-----------------------------------------------------------------------------------------	
void	traite_block_journal(block_type_journal*	blk)
{
int i,code,blocknum;
if(!fenetre(fenetre_journal)) nouveauT(fenetre_journal,0,"journal");

//printf("ecrit une page du journal \n");
for(i=0;i<long_page;i++)
	{
	code=type_block(&blk->jj[i]);
	blocknum=numero_block(&blk->jj[i]);
	if(code) break;	// code vaut 1 pour vider une page de journal incomplete
	ecritT(fenetre_journal,fin_f,"block_num= %d   code %d   ==>  %d %d %d %d %d %d %d %d \n",
		blocknum,code,
		blk->jj[i].mot[0],blk->jj[i].mot[1],blk->jj[i].mot[2],blk->jj[i].mot[3],
		blk->jj[i].mot[0],blk->jj[4].mot[5],blk->jj[i].mot[6],blk->jj[i].mot[7]);
	}
}

//-----------------------------------------------------------------------------------------	
//  -------------     block type 2 : block_reglage   ------------------    ------------
//-----------------------------------------------------------------------------------------	
void	traite_block_reglage(block_type_reglage*	blk)
{
	
//printf(" recut un block reglage  ***********************************  \n\n");	
		
gg->reglage=blk->reglage;
tt->reglage=blk->reglage;
rafraichis_fenetres();
}


//-----------------------------------------------------------------------------------------	
//  ---------------------     block type 3 : lit les data dilution     ------------------------
//-----------------------------------------------------------------------------------------	
//
//  fonction  void	traite_block_dilution(block_type_dilution*blk)
//
//   la fonction est dans le module dilution.c



//-----------------------------------------------------------------------------------------	
//  ---------------------     block type 4 : lit la chaine GPS     ------------------------
//-----------------------------------------------------------------------------------------	
void	traite_block_gps(block_type_gps*	blk)
{
int i;		
char c1;
if(!fenetre(fenetre_GPS)) nouveauT(fenetre_GPS,0,"lecture GPS");

//printf("ecrit une ligne GPS \n");

if(blk->gps[0])
	{
	ecritT(fenetre_GPS,fin_f,"gps --> ");
	for(i=0;i<80;i++)			
		{
		c1=blk->gps[i];
		if (c1)	ecritT(fenetre_GPS,fin_f,"%c",c1&0x7f);
		else	i=80;
		if(c1==13) i=80;
		}
	}
}



//-----------------------------------------------------------------------------------------	
//  -------------     block type 5 : lit les courbes de bolos individuelles    ------------
//	nb_per_block est le nombre de periodes entieres dans le block  
//   	-->  le nombre de courbes lues est egal a nb_per_block qui doit etre <= nb_max_bolo 
//-----------------------------------------------------------------------------------------
void	traite_block_une_periode(block_type_une_periode*	blk)
{
int j,i;		
for(j=0;j<nb_max_bolo;j++)	for (i=0;i<gg->reglage.horloge.nb_mesures;i++)
		gg->bol_per[j][i]=blk->bol_per[j][i]^0x7fff;	// 16 bit -> 15 bit utile + phase
								// change le signe des 15 bits utiles		
affi_bolo();			// affichage des bolo individuels
}




//-----------------------------------------------------------------------------------------	
//  -------------     block type 6 : block_synchro_sol   ------------------    ------------
//-----------------------------------------------------------------------------------------	
void	traite_block_synchro_sol(block_type_synchro_sol*	blk)
{
blk_sync2 = *blk;
// ne fait rien: le block synchro precede toujours le block bolo
}




//-----------------------------------------------------------------------------------------	
//  ---------------------     block type 12 : dcomprime les donnes bolo      ------------
//-----------------------------------------------------------------------------------------	
void	traite_block_bolo_comprime(block_type_bolo_comprime*	blk)
{		
int j;
#define blk2  ((block_type_bolo*)(&bktm)) 	// pointeur sur la memoire locale
// maintenant, decomprime  blk  pour le reecrire dans blk2
/*printf("comprime: ds1= %x  , %x  ds2= %x  , %x   ",
	( (blk->data_bolo[0][0] & 0xffff0000)>>11 ) & 0x001fffe0,
	( (blk->data_bolo[0][0] & 0x0000ffff)<<5 )  & 0x001fffe0,
	( (blk->data_bolo[1][0] & 0xffff0000)>>11 ) & 0x001fffe0,
	( (blk->data_bolo[1][0] & 0x0000ffff)<<5 )  & 0x001fffe0);
*/
for(j=0;j<nb_bolo_util;j++)	
		{
		decompress_7_2((long *)blk->data_bolo[j],blk2->data_bolo[j],nb_per_block*2);
		}

/*printf("ds1= %x  , %x  ds2= %x  , %x   \n",
					blk2->data_bolo[0][0],
					blk2->data_bolo[0][1],
					blk2->data_bolo[1][0],
					blk2->data_bolo[1][1]);
*/
valide_block(&bktm,block_bolo,numero_block(blk));	// pour recopier le numero de block
traite_block_bolo(blk2);
}




//-----------------------------------------------------------------------------------------	
//  -------------     block type 8 : block_bolo   ------------------    ------------
//-----------------------------------------------------------------------------------------	
void	traite_block_bolo(block_type_bolo*	blk)
{
static num_block_local;
int i,j,nb_coups,glitch;	
static ancien_don_bolo[nb_max_bolo];
int	secondes;

glitch=litD(fenetre_acquisition,e_deglitch,0L);

num_block_local++;
if(num_block_local!=numero_block(blk)) {printf(" erreur numblock=%d\n",numero_block(blk));num_block_local=numero_block(blk);}

secondes=(int) (gg->periode_echantillonage*(double)num_block_local*(double)nb_per_block*2.);
//printf("numblock=%d  sec=%d \n",num_block_local,secondes);
ecritD(fenetre_controle,con_time,"%d",secondes);

nb_coups= gg->reglage.horloge.nb_mesures/2 - gg->reglage.horloge.temp_mort;

/*
if( (num_block_local%10)==0)	//  impression des valeurs un block sur 10
	{
	int aa = (nb_coups<<14) + (nb_coups*190) ;
	printf(" nb coups dans une somme : %d \n",nb_coups);
	for(j=0;j<20;j+=2)	
		printf("ds1= %x  , %x  ds2= %x  , %x   ",
					blk->data_bolo[0][j],
					blk->data_bolo[0][j+1],
					blk->data_bolo[1][j],
					blk->data_bolo[1][j+1]);
		printf("ds1= %8.1f  , %8.1f  ds2= %8.1f  , %8.1f   \n",
					(double)(blk->data_bolo[0][j]- aa),
					(double)(blk->data_bolo[0][j+1]- aa),
					(double)(blk->data_bolo[1][j]- aa),
					(double)(blk->data_bolo[1][j+1]- aa));
	}
*/
			
//  -------------      lit les valeur detection synchrone     ------------------

#define  val_DS(j,i)  (blk->data_bolo[j][i]&0x1fffff)
//#define  synchro_DS(j,i)	((blk->data_bolo[j][i]>>20)&1)

for (i=0;i<nb_per_block*2;i++)
	{
	int aa,s;
	aa = (nb_coups<<14) + (nb_coups*190) ;
	if( i%2) s=1;else	s=-1;

	for(j=0;j<nb_max_bolo;j++)	
		{
		gg->don.don_bolo[j]=0.5*(ancien_don_bolo[j]+s*(((val_DS(j,i)-aa)<<1)/nb_coups));		// copy bolos
		ancien_don_bolo[j]=s*(((val_DS(j,i)-aa)<<1)/nb_coups);
		}

	for(j=0;j<nb_sync;j++)	
		{
		gg->don.sync[j]=blk_sync2.synchro[i][j];
		}
	
	
//	gg->don.sync[j]=synchro_DS(j,i);	

	gg->temps_cntl=num_block_local*nb_per_block*2+i;	// temps controlleur en demi-periodes		
//	printf("gg->temps_cntl=%d  \n",gg->temps_cntl);
//	exec_synchro(0,100,err);	// en premier pour construire le flag  scan_en_cours 
	exec_synchro(0,100,0);		// en premier pour construire le flag  scan_en_cours 
		//  le trace ds et 1p est fait avec les points corelles du coups precedent !!!
	
	GetDateTime(&gg->temps_mac);
	if(gg->fichier_dia2_ouvert)  	ecrit_fichier_dia2(gg->don,gg->temps_cntl,gg->temps_mac);		// ecrit les donnees dans le fichier  
	
	if(glitch)	deglitch();
	corel();
	
	//if(gg->trace_ouvert&1)		exec_trace_tout(fenetre_trace_tout,tache_de_fond,0);
	for(j=0;j<8;j++)	if(gg->trace_tout[j]) exec_trace_tout(gg->trace_tout[j],tache_de_fond,0);
	if( (gg->trace_ouvert&16)  && 	// trace carte et pas de select synchro
	  (! (gg->trace_ouvert&32)))	trace_annexe(gg->corel);
	if(gg->flag_fou)		foufou();	
	if(gg->trace_ouvert&8)		exec_ondelette(fenetre_ondelette,0,0);
	
	
	}

	// _____________  affichage numerique de la valeur d'un bolometre  _______________
j=litD(fenetre_acquisition,e_bolo,0L)-1;  
if( (j<0) ou (j>=nb_max_bolo) )	ecritD(fenetre_acquisition,e_valeur,"--");
	else				ecritD(fenetre_acquisition,e_valeur,"b%d=%g V",j+1,xbol(j));
		

}




#ifdef	transmet_data_brute
//-----------------------------------------------------------------------------------------	
//  -------------     block type 15 : lit data brute  (block recut de l'EPLD)   ------------    ------------
//  -------------     		utilise uniquement pour la mise au point       ------------
//-----------------------------------------------------------------------------------------	
void	traite_block_data_brute(block_type_data_brute*	blk)
{
int i,k;		
static int qq=0;
qq++;
//if(qq>20)
	{
	qq=0;
	printf(" data brutes : ");
	for(k=0;k<10;k+=5)	{printf("  ");for (i=0;i<5;i++)	printf(" %x", (unsigned char) blk->data[k+i+1]);}
	printf("\n");
	for(k=0;k<nb_per_block;k++)	printf("%d",(blk->data[k*tt->reglage.horloge.nb_mesures*nb_byte_mot+5]>>6)&0x3);
	printf("\n");
//	for(k=0;k<2;k++)
		{
//		printf("%d",(blk->data[k*tt->reglage.horloge.nb_mesures*nb_byte_mot+2]>>6)&0x3);
		for(i=0;i<tt->reglage.horloge.nb_mesures;i++)	
			{
//			printf("%d",(blk->data[(k*tt->reglage.horloge.nb_mesures+i)*nb_byte_mot+5]>>6)&0x3);
			}
//		printf("\n");		
		}

	}
}
#endif



 
#endif

