#include "piwindowmac.h"

PIWindowMac::PIWindowMac(PIMsgHandler *par, char *nom, PIWindowKind k, int sx, int sy, int px, int py)
: PIWindowGen(par, nom, k, sx, sy, px, py), finalized(false)
{
	delete mPane;
	delete mAdapter;
	mAdapter = NULL;
	mWindowInfo.WINDid = 1000+k;
	mWindowInfo.attributes = windAttr_EraseOnUpdate |
	                         windAttr_Targetable |
	                         windAttr_Enabled;
	switch (k) {
	 case PIWK_normal:
	  mWindowInfo.attributes |= windAttr_Regular | 
	                            windAttr_TitleBar |
	                            windAttr_SizeBox |
	                            windAttr_CloseBox |
	                            windAttr_Resizable;
	  mWindowInfo.layer = windLayer_Regular;
	  break;
	 case PIWK_dialog:
	  mWindowInfo.attributes |= windAttr_Modal;
	  mWindowInfo.layer = windLayer_Modal;
	  break;
	 case PIWK_floating:
	  mWindowInfo.attributes |= windAttr_Floating |
	                            windAttr_HideOnSuspend;
	  mWindowInfo.layer = windLayer_Floating;
	  break;
	}
	mWindowInfo.minimumWidth = 30;
	mWindowInfo.minimumHeight = 30;
	mWindowInfo.maximumWidth = 32000;
	mWindowInfo.maximumHeight = 32000;
	mWindowInfo.standardSize.width = sx;
	mWindowInfo.standardSize.height = sy;
	mWindowInfo.userCon = 0;
	
	//mPane = new LWindow(mWindowInfo);
	mPane = LWindow::CreateWindow(1000+k,LCommander::GetTopCommander());
	Rect r = {py, px, py+sy, px+sx};
    ((LWindow*) mPane)->DoSetBounds(r);
    SetLabel(nom);
    //((LWindow*) mPane)->SetSuperCommander(LCommander::GetTopCommander());
}


PIWindowMac::~PIWindowMac()
{}


void PIWindowMac::Show()
{
  if (!finalized) {
    FinishCreate();
    finalized = true;
  }
  PIWindowGen::Show();
}

void
PIWindowMac::SetSize(int sx, int sy)
{
   ((LWindow*) mPane)->ResizeWindowTo(sx, sy);
}

void
PIWindowMac::SetPos(int px, int py)
{
   ((LWindow*) mPane)->MoveWindowTo(px-XPos(), py-YPos());
}
