#ifndef PICMAPX_H_SEEN
#define PICMAPX_H_SEEN

#include "picmapgen.h"

typedef   unsigned long PIXColor ;


class PIColorMapX : public PIColorMapGen {
public:
  PIColorMapX();  
  PIColorMapX(int id, int nc, string const& nom);  
  virtual ~PIColorMapX();

  inline PIXColor  Color(int index) 
    { return ((index < mNCol) ? mColors[index] : 0); } ;

  virtual PIColor GetColor(int n);
  virtual bool AllocColor(PIColor const& col, int index);
  virtual void FreeColors();

  virtual long TotNbColors();
  virtual int  NbAllocColors();

protected:
  virtual void CopyFrom(PIColorMapGen*);
  
  PIXColor  * mColors;     // La table des couleurs ...
  PIColor   * mColRGB;     // Composantes RGB  
};

typedef PIColorMapX PIColorMapNative;

#endif
