#include <manip.h>
#include "compress.h"


//*******************************************************************************************
//****************   			 											*****************
//****************   			 		decompress_3							*****************
//****************   			 											*****************
//*******************************************************************************************

#define	ecart_mask		0x7	/*	masque pour l'ecart		*/		

void  decom_3(long val,long* in,long*out,int n);

#define	k_mask	0xf		/*	masque pour l'exposant		*/
#define	sgbi_	0x4		/*	bit de signe de l'ecart		*/
#define	sign_	0xfffffff8	/*	masque de signe de l'ecart	*/

//  compress un tableau in de n*9 points dispos avec un pas pasin
//  les data compresses sont ecrites dans le tableau out de n points
//  la valeur val est la valeur de reference du point origine

/*  comprime	9*n points  : 1er point dans 1er mot, tous les ecarts dans les n mots suivants		*/ 
/*	9*n	==>	n+1	    pour  72 points :   9 mots			*/


void decompress_3_1(long* in,long*out,int n)
{
long val;
val=	*in;
decom_3(val,in+1,out,n/9);
}



void  decom_3(long val,long* in,long*out,int n)
{
register long R;
long ec1,ec2,ec3,ec4,ec5,ec6,ec7,ec8,ec9;
int i,k;

for(i=0;i<n;i++)
	{
	R=in[i];
	k=R&k_mask;
	recup(ec1,29,k); 
	recup(ec2,26,k); 
	recup(ec3,23,k); 
	recup(ec4,20,k); 
	recup(ec5,17,k); 
	recup(ec6,14,k); 
	recup(ec7,11,k);
	recup(ec8,8,k);
	recup(ec9,5,k);
	
	val+=ec1; 	out[i*9]=val;	 
	val+=ec2;	out[i*9+1]=val;	 
	val+=ec3;	out[i*9+2]=val;	 
	val+=ec4;	out[i*9+3]=val;	 
	val+=ec5;	out[i*9+4]=val;	 
	val+=ec6;	out[i*9+5]=val;	 
	val+=ec7;	out[i*9+6]=val;	 
	val+=ec8;	out[i*9+7]=val;	 
	val+=ec9;	out[i*9+8]=val;	 
	}
}



//*******************************************************************************************
//****************   			 											*****************
//****************   			 		decompress_4							*****************
//****************   			 											*****************
//*******************************************************************************************

void  decom_4(long val,long* in,long*out,int n);
void  decom_4_paire(long val1,long val2,long* in,long*out,int n);

#undef	ecart_mask		
#define	ecart_mask	0xf		/*	masque pour l'ecart		*/		
#undef	sgbi_
#undef	sign_



#define	k_mask	0xf		/*	masque pour l'exposant		*/
#define	sgbi_	0x8		/*	bit de signe de l'ecart		*/
#define	sign_	0xfffffff0	/*	masque de signe de l'ecart	*/


/*  comprime	7*n + 2  points  (de 16 bit chacun)  				*/
/*	1er et 2 eme point dans 1er mot, les ecarts dans les n mots suivants	*/ 
/*	7*n + 2	==>	n+1	     ==>   pour  72 points :   11 mots  	*/


void decompress_4_1(long* in,long*out,int n)
{
long val1,val2;
val1=	( (*in & 0xffff0000)>>16 ) & 0x0000ffff;
val2=	( (*in & 0x0000ffff)     )  & 0x0000ffff;
out[0]=val1;
out[1]=val2;
decom_4(val2,in+1,out+2,n/7);
}



void  decom_4(long val,long* in,long*out,int n)
{
register long R;
long ec1,ec2,ec3,ec4,ec5,ec6,ec7;
int i,k;

for(i=0;i<n;i++)
	{
	R=in[i];
	k=R&k_mask;
	recup(ec1,28,k); 
	recup(ec2,24,k); 
	recup(ec3,20,k); 
	recup(ec4,16,k); 
	recup(ec5,12,k); 
	recup(ec6,8,k); 
	recup(ec7,4,k);
	
	val+=ec1; 	out[7*i]=val;	 
	val+=ec2;	out[7*i+1]=val;	 
	val+=ec3;	out[7*i+2]=val;	 
	val+=ec4;	out[7*i+3]=val;	 
	val+=ec5;	out[7*i+4]=val;	 
	val+=ec6;	out[7*i+5]=val;	 
	val+=ec7;	out[7*i+6]=val;	 
	}
}

/********************************************************************************************/

/*  compresse en 4 bit mais par paire (pour data provenant de la detection synchrone)		*/

/*     21 bit maleur maximum									*/
/*  comprime	7*n+2 points  : 1er et 2eme point dans 1er et 2eme mot, suite dans n mots	*/
/*		diffrences entre valeures paires  et entre valeures impaires uniquement	*/ 
/*	7*n+2	==>	n+2		==>  pour 72 points :	12 mots				*/


void decompress_4_2(long* in,long*out,int n)
{
long val1,val2;
val1=in[0];		val2=in[1];
out[0]=val1;	out[1]=val2;
decom_4_paire(val1,val2,in+2,out+2,n/7);
}


void  decom_4_paire(long val1,long val2,long* in,long*out,int n)
{
register long R;
long ec1,ec2,ec3,ec4,ec5,ec6,ec7;
int i,k;

for(i=0;i<n;i++)
	{
	R=in[i];
	k=R&k_mask;
	recup(ec1,28,k); 
	recup(ec2,24,k); 
	recup(ec3,20,k); 
	recup(ec4,16,k); 
	recup(ec5,12,k); 
	recup(ec6,8,k); 
	recup(ec7,4,k);
	
//	printf("i=%d  k=%d  ec= %d %d %d    \n",i,k,ec1,ec2,ec3);


	val1+=ec1; 	out[7*i]=val1;	 
	val2+=ec2;	out[7*i+1]=val2;	 
	val1+=ec3;	out[7*i+2]=val1;	 
	val2+=ec4;	out[7*i+3]=val2;	 
	val1+=ec5;	out[7*i+4]=val1;	 
	val2+=ec6;	out[7*i+5]=val2;	 
	val1+=ec7;	out[7*i+6]=val1;
	R=val1;val1=val2;val2=R;	 
	}
}


//*******************************************************************************************
//****************   			 											*****************
//****************   			 		compress_7							*****************
//****************   			 											*****************
//*******************************************************************************************

#undef	sgbi_
#undef	sign_


#undef	ecart_mask		
#define	ecart_mask		0x7f		/*	masque pour l'ecart 7 bits		*/		
#define	sgbi_	0x40		/*	bit de signe de l'ecart		*/
#define	sign_	0xffffff80	/*	masque de signe de l'ecart	*/


/*  comprime	4*n points  : 1er point dans 1er mot, tous les ecarts dans les n mots suivants		*/ 
/*	4*n	==>	n+1	*/

void  decom_7(long val,long* in,long*out,int n);

void decompress_7_1(long* in,long*out,int n)
{
long val;
val=*in;
*out=val;
decom_7(val,in+1,out,n/4);
}



/*  compress un tableau in de n*4 points dispos avec un pas pasin	*/
/*  les data compresses sont ecrites dans le tableau out de n points	*/
/*  la valeur val est la valeur de reference du point origine	*/

void  decom_7(long val,long* in,long*out,int n)
{
register long R;
long ec1,ec2,ec3,ec4;
int i,k;

for(i=0;i<n;i++)
	{
	R=in[i];
	k=R&k_mask;
	recup(ec1,25,k); 
	recup(ec2,18,k); 
	recup(ec3,11,k); 
	recup(ec4,4,k); 
	
	val+=ec1; 	out[4*i]=val;	 
	val+=ec2;	out[4*i+1]=val;	 
	val+=ec3;	out[4*i+2]=val;	 
	val+=ec4;	out[4*i+3]=val;	 
	}
}

/********************************************************************************/
/*  compresse en 7 bit mais par paire (pour data de la detection synchrone	*/
/* 21 bit maleur maximum							*/
/*  comprime	4*n points  : 1er et 2eme point dans 1er mot (16 bit chacun),	*/
/*				 suite dans n mots				*/
/*	diffrences entre valeures paires  et entre valeures impaires uniquement*/ 
/*			4*n	==>	n+1					*/
/********************************************************************************/

void  decom_7_paire(long val1,long val2,long* in,long*out,int n);

void decompress_7_2(long* in,long*out,int n)
{
long val1,val2;
val1=	( (*in & 0xffff0000)>>11 ) & 0x001fffe0;
val2=	( (*in & 0x0000ffff)<<5 )  & 0x001fffe0;
/*printf("val1=%x  val2=%x  \n",val1,val2);*/
decom_7_paire(val1,val2,in+1,out,n/4);
}


void  decom_7_paire(long val1,long val2,long* in,long*out,int n)
{
register long R;
long ec1,ec2,ec3,ec4;
int i,k;

for(i=0;i<n;i++)
	{
	R=in[i];
	k=R&k_mask;
	recup(ec1,25,k); 
	recup(ec2,18,k); 
	recup(ec3,11,k); 
	recup(ec4,4,k); 
	
	val1+=ec1; 	out[4*i]=val1;	 
	val2+=ec2;	out[4*i+1]=val2;	 
	val1+=ec3;	out[4*i+2]=val1;	 
	val2+=ec4;	out[4*i+3]=val2;	 

/*if(i<5)  printf("in=%x  i=%d  k=%d  ec= %x %x %x %x  \n",R,i,k,ec1,ec2,ec3,ec4);*/	

	}
}


