#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "tm.h"
#include "tache.h"
#include "bolo.h"
#include "carte_acqui.h"
#include "carte_pci.h"
#include "bit_block.h"





//*****************************************************************************************
//											***
#ifdef _archeops		//---------   pour  Archeops    -----------------------	***
#ifndef _sans_transputer	//---------   pour  Archeops avec transputer    -------------	***
//											***
//*****************************************************************************************
//
//
//   lit directement les blocks recut sur la fifo et les envoie au programme principal
//


#define avance_erreur  {tt->te.pos_ecrit++; if(tt->te.pos_ecrit>=long_table_err) tt->te.pos_ecrit=0;}
#define	ecrit_erreur(xx)	{avance_erreur;tt->te.err[tt->te.pos_ecrit]=900+(xx);}
void	sauve_un_block(tmtc* tt);

	

//*****************************************************************************************

void init_tache(void)
{
tt->vi.a=0;
tt->vi.b=0;
tt->vi.c=0;
//init_lit_bit();
}


#define	max_fifo  4000



char	un_bit(void)
{
static int i;
static unsigned long RR;
i++;
if( (i<0) ou (i>7) ) 
	{
	lit_carte;	if(rien_a_lire)		return(bit_vide);	//  fifo vide  ->  retour  ->  sort du while
	i=0;
	}
if( (RR>>i) & 1 )  	return(bit_un);
	else		return(bit_zero);
}



void	ecrit_erreur_bit(int e)
{
ecrit_erreur(e+20);
}






void lecture_fifo(void* tx)	// appell directement pour acquisition en interruptions
{
tmtc* tt=(tmtc*)tx;
long lec_fifo=0;		//  compteur nombre de points lut en une fois dans la fifo
char*	t_char=(char*)(&tt->vi.btt);
int i;


if(tt->PCI_actif==2)	// simulation Archeops
	{
	static int numblock=0;
	tt->vi.a++;
	if(tt->vi.a>20)	// ecrit un block toutes les 20 interruptions (soit 0.5 sec)
		{
		int i;
		tt->vi.a=0;
		numblock++;

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_bolo,numblock);
		sauve_un_block(tt);

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_une_periode,numblock);
		sauve_un_block(tt);

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_dilution,numblock);
		sauve_un_block(tt);

		}
	}

else	while(1)
	{
	i=lit_bit(&tt->vi.btt);
	if(i==lit_bit_vide)	break;
	if(i==lit_bit_un_block)	sauve_un_block(tt);

	lec_fifo++;	
	if(lec_fifo>max_fifo*8) 	break;		// parceque compte les bit et non les octets
	}
if(lec_fifo > tt->nb_lec_fofo_int)  	tt->nb_lec_fofo_int=lec_fifo;
if(!tt->nb_lec_fofo_ext)  		{tt->nb_lec_fofo_ext=tt->nb_lec_fofo_int;tt->nb_lec_fofo_int=0;}

}



//______________________________________________________________________________________________//
//   lit le block brut tel que recut par telemesure dans  tt->vi.btt				//
//	ce block contient  ??  periodes de mesure						// 
// 	Je rempli un block tm  en position	u=tt->tm.pos_ecrit				//
//	Le block s'ecrit: 			tt->tm.btm[u]					//
//______________________________________________________________________________________________//



void	sauve_un_block(tmtc* tt)
{
int u;
//ecrit_erreur(err_recut_un_block_ok);

u=tt->tm.pos_ecrit;
//  le code de debut n'a pas t ecrit dans le block : il faut l'ecrire
tt->vi.btt.debut=debut_block_mesure;
tt->tm.btm[u].tmtrx=tt->vi.btt;	// recopie le block courant dans la table
u++; if(u>=longueur_table_tm) u=0;
tt->tm.pos_ecrit=u;

if(tt->tm.pos_ecrit==tt->tm.pos_lit)  ecrit_erreur(err_pile_pleine);
}

//*****************************************************************************************
//											***
#endif		//--------------------------------------------------------------------	***
#endif		//--------------------------------------------------------------------	***
//											***
//*****************************************************************************************




